<?php
/**
* @version	$Id: form_submissions_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'formsubs',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'FormSubmissionsEventHandler','file'=>'form_submissions_eh.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'FormSubmissionTagProcessor', 'file' => 'form_submission_tp.php', 'build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),

					'Hooks'				=>	Array(
											Array(
												'Mode' => hAFTER,
												'Conditional' => false,
												'HookToPrefix' => 'formsubs', //self
												'HookToSpecial' => '*',
												'HookToEvent' => Array('OnAfterConfigRead'),
												'DoPrefix' => '',
												'DoSpecial' => '',
												'DoEvent' => 'OnBuildFormFields',
											),
										),

					'TitlePresets'		=>	Array(
						'default'	=>	Array(	'new_status_labels'		=> Array('form'=>'!la_title_Adding_Form!'),
												'edit_status_labels'	=> Array('form'=>'!la_title_Editing_Form!'),
												'new_titlefield'		=> Array('form'=>''),
										),

						'formsubs_list' => Array (
									'prefixes' =>	Array('form', 'formsubs_List'),
									'format' =>	"!la_title_FormSubmissions! '#form_titlefield#'",
									'toolbar_buttons' => Array ('edit', 'delete', 'dbl-click'),
								),

						'formsubs_view' => Array(
									'prefixes' => Array('formsubs'),
									'format' => "!la_title_ViewingFormSubmission!",
									'toolbar_buttons' => Array ('cancel', 'prev', 'next'),
								),

							),

					'PermSection'		=>	Array('main' => 'in-portal:submissions'),

					'IDField'			=>	'FormSubmissionId',
					/*'TitleField'		=>	'Name',*/
					'TableName'			=>	TABLE_PREFIX.'FormSubmissions',
					'ListSQLs'	=>	Array(
							''=>'	SELECT %1$s.* %2$s FROM %1$s',
						), // key - special, value - list select sql
					'ItemSQLs'	=>	Array(
								''=>'SELECT %1$s.* %2$s FROM %1$s',
						),

					/*'ForeignKey'	=>	'FormId',
					'ParentTableKey' => 'FormId',
					'ParentPrefix' => 'form',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,*/

					'ListSortings'	=> 	Array(
						'' => Array(
							'Sorting' => Array('SubmissionTime' => 'desc'),
						)
					),

					'Fields'	=>	Array(
							'FormSubmissionId' => Array('type' => 'int', 'not_null' => 1,'default' => 0),
							'FormId' => Array('type' => 'int','not_null' => '1','default' => 0),
							'SubmissionTime' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
					),
					'VirtualFields'	=>	Array(
					),
					'CalculatedFields'	=>	Array(
					),
					'Grids'	=> Array(
						'Default'		=>	Array(
							'Icons' => Array('default' => 'icon16_item.png'),
							'Fields' => Array(
								'FormSubmissionId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'sort_field' => 'FormFieldId', 'filter_block' => 'grid_range_filter', 'width' => 60 ),
								'SubmissionTime' => Array( 'title'=>'la_prompt_SumbissionTime', 'filter_block' => 'grid_date_range_filter', 'width' => 145 ),
							),
						),
					),
	);