<?php
/**
* @version	$Id: mailing_lists_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'mailing-list',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'MailingListEventHandler', 'file' => 'mailing_list_eh.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'MailingListTagProcessor', 'file' => 'mailing_list_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'RegularEvents' => Array (
			'generate_mailing_queue' => Array ('EventName' => 'OnGenerateEmailQueue', 'RunInterval' => 1800, 'Type' => reAFTER),
			'process_mailing_queue' => Array ('EventName' => 'OnProcessEmailQueue', 'RunInterval' => 1800, 'Type' => reAFTER),
		),

		'IDField' => 'MailingId',

		'TableName' => TABLE_PREFIX . 'MailingLists',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('mailing-list' => '!la_title_AddingMailingList!'),
				'edit_status_labels' => Array ('mailing-list' => '!la_title_ViewingMailingList!'),
			),

			'mailing_list_list' => Array (
				'prefixes' => Array ('mailing-list_List'), 'format' => "!la_title_MailingLists!",
				'toolbar_buttons'		=> Array ('new_item', 'edit', 'delete', 'primary_theme', 'clone', 'view', 'dbl-click'),
			),

			'mailing_list_edit' => Array (
				'prefixes' => Array ('mailing-list'), 'format' => "#mailing-list_status#",
				'toolbar_buttons'		=> Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array('main' => 'in-portal:mailing_lists'),

		'Sections' => Array (
			'in-portal:mailing_folder' => Array (
				'parent'		=>	'in-portal:users',
				'icon'			=>	'mailing_list',
				'label'			=>	'la_title_MailingLists',
				'use_parent_header' => 1,
				'permissions'	=>	Array (),
				'priority'		=>	5,
				'type'			=>	stTREE,
			),

			'in-portal:mailing_lists' => Array (
				'parent'		=>	'in-portal:mailing_folder',
				'icon'			=>	'mailing_list',
				'label'			=>	'la_title_MailingLists',
				'url'			=>	Array('t' => 'mailing_lists/mailing_list_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	5.1, // <parent_priority>.<own_priority>, because this section replaces parent in tree
				'type'			=>	stTAB,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('MailingId' => 'desc'),
			)
		),

		'Fields' => Array (
			'MailingId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),

			'PortalUserId' => Array(
				'type' => 'int',
				'formatter' => 'kLEFTFormatter',
				'options' => Array (-1 => 'root'),
				'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'PortalUser WHERE `%s` = \'%s\'', 'left_key_field' => 'PortalUserId', 'left_title_field' => 'Login',
				'required' => 1, 'not_null' => 1, 'default' => -1,
			),

			'To' => Array ('type' => 'string', 'required' => 1, 'default' => NULL),
			'ToParsed' => Array ('type' => 'string', 'default' => NULL),

			'Attachments' => Array (
				'type' => 'string',
				'formatter' => 'kUploadFormatter', 'upload_dir' => ITEM_FILES_PATH, 'max_size' => 50000000,
				'multiple' => 10, 'direct_links' => true, 'file_types' => '*.*', 'files_description' => '!la_hint_AllFiles!',
				'default' => NULL
			),

			'Subject' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
			'MessageText' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
			'MessageHtml' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),

			'Status' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_opt_NotProcessed', 2 => 'la_opt_PartiallyProcessed', 3 => 'la_opt_Processed', 4 => 'la_opt_Cancelled'), 'use_phrases' => 1,
				'not_null' => 1, 'required' => 1, 'default' => 1
			),

			'EmailsQueued' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'EmailsSent' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'EmailsTotal' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),
				'Fields' => Array (
					'MailingId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
					'Subject' => Array ('title' => 'la_col_Subject', 'filter_block' => 'grid_like_filter', 'width' => 200,  ),
					'MessageText' => Array ('title' => 'la_col_MessageText', 'filter_block' => 'grid_like_filter', 'cut_first' => 100, 'width' => 120, ),
					'MessageHtml' => Array ('title' => 'la_col_MessageHtml', 'filter_block' => 'grid_like_filter', 'cut_first' => 100, 'width' => 120, ),
					'Status' => Array ('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
					'EmailsQueued' => Array ('title' => 'la_col_EmailsQueued', 'filter_block' => 'grid_range_filter', 'width' => 80, ),
					'EmailsSent' => Array ('title' => 'la_col_EmailsSent', 'filter_block' => 'grid_range_filter', 'width' => 80, ),
					'EmailsTotal' => Array ('title' => 'la_col_EmailsTotal', 'filter_block' => 'grid_range_filter', 'width' => 80, ),
				),
			),
		),
	);