<?php
/**
* @version	$Id: clipboard_helper.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class kClipboardHelper extends kHelper {

		/**
		 * Set's clipboard mode
		 *
		 * @param kEvent $event
		 * @param string $mode
		 */
		function setClipboard(&$event, $mode, $ids)
		{
			// clipboard = { prefix1 = { cut = {idsA}, copy = {idsB} }, ... prefixN = { cut = {idsC}, copy = {idsD} } }
			$object = $event->getObject();

			$clipboard = $this->Application->RecallVar('clipboard');
			$clipboard = $clipboard ? unserialize($clipboard) : Array();

			$prefix = $event->getPrefixSpecial();

			// 1. add $ids to mode key for prefix (make sure the unique)
			$this_mode_ids =& $clipboard[$prefix][$mode];
			if (!is_array($this_mode_ids)) {
				$this_mode_ids = $ids;
			}
			else {
				$this_mode_ids = array_unique( array_merge($this_mode_ids, $ids) );
			}

			// 2. remove that ids from all other modes
			$other_mode_ids =& $clipboard[$prefix][$mode == 'cut' ? 'copy' : 'cut'];
			if (!is_array($other_mode_ids)) {
				$other_mode_ids = Array();
			}
			else {
				$other_mode_ids = array_diff($other_mode_ids, $this_mode_ids);
			}

			$this->Application->StoreVar('clipboard', serialize($clipboard));

			/*// do not go up - STAY
			$event->SetRedirectParam('opener', 's');
			$event->SetRedirectParam('pass_events', true);*/
		}
	}