<?php
/**
* @version	$Id: search_logs_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'search-log',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'SearchLogId',

		'TableName' => TABLE_PREFIX . 'SearchLog',

		'TitlePresets' => Array (
			'search_log_list' => Array (
				'prefixes' => Array('search-log_List'), 'format' => '!la_tab_SearchLog!',
				'toolbar_buttons' => Array ('refresh', 'delete', 'reset', 'export', 'view', 'dbl-click'),
				),
		),

		'PermSection' => Array ('main' => 'in-portal:searchlog'),

		'Sections' => Array (
			'in-portal:searchlog' => Array (
				'parent'		=>	'in-portal:reports',
				'icon'			=>	'search_log',
				'label'			=>	'la_tab_SearchLog',
				'url'			=>	Array('t' => 'logs/search_logs/search_log_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'delete'),
				'priority'		=>	4,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Keyword' => 'asc'),
			)
		),

		'Fields' => Array (
			'SearchLogId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Keyword' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'Indices' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'SearchType' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Text_Simple', 1 => 'la_Text_Advanced'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_item.png'),
				'Fields' => Array (
					'SearchLogId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
					'Keyword' => Array ('title' => 'la_col_Keyword', 'filter_block' => 'grid_like_filter', 'width' => 300,  ),
					'SearchType' => Array ('title' => 'la_prompt_SearchType', 'filter_block' => 'grid_options_filter', 'width' => 110,  ),

					'Indices' => Array ('title' => 'la_prompt_Frequency', 'filter_block' => 'grid_range_filter', 'width' => 100,  ),
				),
			),
		),
	);