<?php
/**
* @version	$Id: configuration_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'conf',
		'ItemClass' => Array ('class' => 'ConfigurationItem', 'file' => 'configuration.php', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'ConfigurationEventHandler', 'file' => 'configuration_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'ConfigurationTagProcessor', 'file' => 'configuration_tag_processor.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'VariableId',
		'TitleField' => 'VariableName',

		'TitlePresets' => Array (
			'default' => Array ('tag_params' => Array ('conf' => Array ('per_page' => -1))),

			'config_list_general' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),
			'config_list_output' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),
			'config_list_contacts' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),

			'config_list_categories' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),
			'config_list_users' => Array ('prefixes' => Array ('conf_List'), 'format' => "!la_updating_config!"),

			'section_label' => Array ('prefixes' => Array ('conf_List'), 'format' => "#section_label#"),
		),

		'TableName' => TABLE_PREFIX . 'ConfigurationValues',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM ' . TABLE_PREFIX . 'ConfigurationAdmin ca
					LEFT JOIN %1$s USING(VariableName)'
		),



		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('DisplayOrder' => 'asc', 'GroupDisplayOrder' => 'asc'),
			)
		),

		'CalculatedFields' => Array (
			''	=>	Array (
				'heading' => 'ca.heading',
				'prompt' => 'ca.prompt',
				'element_type' => 'ca.element_type',
				'Validation' => 'ca.Validation',
				'ValueList' => 'ca.ValueList',
				'DisplayOrder' => 'ca.DisplayOrder',
				'GroupDisplayOrder' => 'ca.GroupDisplayOrder',
				'Install' => 'ca.Install',
			),
		),

  		'Fields' => Array (
			'VariableId'	=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'VariableName'	=>	Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
			'VariableValue' =>	Array ('type' => 'string', 'default' => null),
			'ModuleOwner'	=>	Array ('type' => 'string', 'default' => 'In-Portal'),
			'Section'		=>	Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		),

		'VirtualFields' => Array (
			'heading'			=>	Array ('type' => 'string', 'default' => ''),
	        'prompt'			=>	Array ('type' => 'string', 'default' => ''),
	        'element_type'		=>	Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
	        'Validation'		=>	Array ('type' => 'string', 'default' => ''),
	        'ValueList'			=>	Array ('type' => 'string', 'default' => ''),
	        'DisplayOrder'		=>	Array ('type' => 'double', 'not_null' => '1', 'default' => 0),
	        'GroupDisplayOrder'	=>	Array ('type' => 'double', 'not_null' => '1', 'default' => 0),
	        'Install'			=>	Array ('type' => 'int', 'not_null' => '1', 'default' => 1),
	        'DirectOptions'		=>	Array ('type' => 'string', 'default' => ''),
		),
	);