<?php
/**
* @version	$Id: images_config.php 13289 2010-03-23 20:59:40Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'img',
					'Clones'	=> Array (
						'bb-post-img'=>	Array('ParentPrefix'	=>	'bb-post'),
					),

					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ImageEventHandler','file'=>'image_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ImageTagProcessor','file'=>'image_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'AggregateTags' => Array (
						Array (
							'AggregateTo' => '#PARENT#',
							'AggregatedTagName' => 'Image',
							'LocalTagName' => 'ItemImageTag',
							'LocalSpecial' => '-item',
						),

						Array (
							'AggregateTo' => '#PARENT#',
							'AggregatedTagName' => 'ImageSrc',
							'LocalTagName' => 'ItemImageTag',
							'LocalSpecial' => '-item',
						),

						Array (
							'AggregateTo' => '#PARENT#',
							'AggregatedTagName' => 'ImageSize',
							'LocalTagName' => 'ItemImageTag',
							'LocalSpecial' => '-item',
						),

						Array (
							'AggregateTo' => '#PARENT#',
							'AggregatedTagName' => 'ListImages',
							'LocalTagName' => 'PrintList2',
							'LocalSpecial' => 'list',
						),

						Array (
							'AggregateTo' => '#PARENT#',
							'AggregatedTagName' => 'LargeImageExists',
							'LocalTagName' => 'LargeImageExists',
						),
					),

					'QueryString'		=>	Array(
						1	=>	'id',
						2	=>	'page',
						3	=>	'event',
					),

					'RegularEvents'		=>	Array (
						'clean_catalog_images' => Array ('EventName' => 'OnCleanImages', 'RunInterval' => 604800, 'Type' => reAFTER, 'Status' => STATUS_DISABLED),
						'clean_resized_catalog_images' => Array ('EventName' => 'OnCleanResizedImages', 'RunInterval' => 2592000, 'Type' => reAFTER, 'Status' => STATUS_DISABLED),
					),

					'IDField'			=>	'ImageId',
					'StatusField'		=>	Array('Enabled', 'DefaultImg'),	// field, that is affected by Approve/Decline events
					'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item
					'TableName'			=>	TABLE_PREFIX.'Images',
					'ParentTableKey'=>	'ResourceId',	// linked field in master table
					'ForeignKey'	=>	'ResourceId',	// linked field in subtable
					'ParentPrefix' => 'p',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array('show_active','show_disabled'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array(
													'show_active'	=>	Array('label' =>'la_Active', 'on_sql' => '', 'off_sql' => 'Enabled != 1' ),
													'show_disabled'	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => 'Enabled != 0'  ),
												)
											),

					'CalculatedFields'	=>	Array(
												''	=>	Array(
															'Preview'	=>	'0',
														),
											),

					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
																'' => Array(
																	'ForcedSorting' => Array('Priority' => 'desc'),
																	'Sorting' => Array('Name' => 'asc'),
																)
															),
					'Fields' => Array (
						'ImageId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
						'ResourceId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
						'Url' => Array('type' => 'string', 'max_len' => 255, 'default' => '', 'not_null' => 1),
						'Name' => Array('type' => 'string', 'max_len' => 255, 'required' => 1, 'not_null' => 1, 'default' => ''),
						'AltName' => Array('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
						'ImageIndex' => Array('type'=>'int', 'default' => 0, 'not_null'=>1),
						'LocalImage' => Array('type'=>'int', 'default' => 1, 'not_null'=>1),
						'LocalPath' => Array(
							'type' => 'string', 'formatter' => 'kPictureFormatter',
							'skip_empty' => 1, 'max_len' => 240, 'default' => '',
							'not_null' => 1, 'include_path' => 1,
							'allowed_types' => Array(
								'image/jpeg', 'image/pjpeg', 'image/png',
								'image/x-png', 'image/gif', 'image/bmp'
							),
							'error_msgs' => Array(
								'bad_file_format' => '!la_error_InvalidFileFormat!',
								'bad_file_size' => '!la_error_FileTooLarge!',
								'cant_save_file' => '!la_error_cant_save_file!',
							),
						),
						'Enabled' => Array (
							'type' => 'int', 'formatter' => 'kOptionsFormatter',
							'options' => Array (1 => 'la_Enabled', 0 => 'la_Disabled',),
							'default' => 0, 'not_null' => 1, 'use_phrases' => 1,
						),
						'DefaultImg' => Array (
						   	'type' => 'int', 'formatter' => 'kOptionsFormatter',
						   	'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
							'default' => 0, 'not_null' => 1, 'use_phrases' => 1,
						),
						'ThumbUrl' => Array('type' => 'string', 'max_len' => 255, 'default' => null),
						'Priority' => Array('type' => 'int', 'default' => 0, 'not_null'=>1),
						'ThumbPath' => Array(
							'type' => 'string', 'formatter' => 'kPictureFormatter',
							'skip_empty' => 1, 'max_len' => 240, 'default' => '',
							'not_null' => 1, 'include_path' => 1,
							'allowed_types' => Array(
								'image/jpeg', 'image/pjpeg', 'image/png',
								'image/x-png', 'image/gif', 'image/bmp'
							),
							'error_msgs' => Array(
								'bad_file_format' => '!la_error_InvalidFileFormat!',
								'bad_file_size' => '!la_error_FileTooLarge!',
								'cant_save_file' => '!la_error_cant_save_file!',
							),
						),
						'LocalThumb' => Array('type' => 'int', 'default' => 1, 'not_null'=>1),
						'SameImages' => Array (
							'type' => 'int', 'formatter' => 'kOptionsFormatter',
							'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
							'default' => 1, 'not_null' => 1, 'use_phrases' => 1,
						),
					),

					'VirtualFields'	=> Array(
						'Preview' => Array(),
						'ImageUrl' => Array(),
					),

					'Grids'	=> Array(
							'Default'		=>	Array(
								'Icons' => Array (
									'default' => 'icon16_item.png',
									'0_0' => 'icon16_disabled.png',
									'0_1' => 'icon16_disabled.png',
									'1_0' => 'icon16_item.png',
									'1_1' => 'icon16_primary.png',
								),
								'Fields' => Array(
									'ImageId' => Array( 'title'=>'la_col_Id', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
									'Name' => Array( 'title'=>'la_col_ImageName' , 'data_block' => 'image_caption_td', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
									'AltName' => Array( 'title'=>'la_col_AltName', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
									'Url' => Array( 'title'=>'la_col_ImageUrl', 'data_block' => 'image_url_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
									'Preview' => Array( 'title'=>'la_col_Preview', 'data_block' => 'image_preview_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
									'Enabled' => Array( 'title'=>'la_col_ImageEnabled', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
									),
								),
							),
	);