<?php
/**
* @version	$Id: filters.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class kMultipleFilter
	{
		var $type = FLT_TYPE_AND;
		var $filters = Array();

		/**
		 * Creates new instance of kMultipleFilter class
		 *
		 * @param int $type
		 * @return kMultipleFilter
		 */
		function &makeClass($type=null)
		{
			$result = new kMultipleFilter($type);
			return $result;
		}

		/**
		 * Creates empty multiple filter
		 *
		 * @param int $type
		 * @return MultipleFilter
		 * @access public
		 */
		function kMultipleFilter($type = FLT_TYPE_AND)
		{
			$this->setType($type);
		}

		/**
		 * Enter description here...
		 *
		 * @param int $new_type
		 */
		function setType($new_type)
		{
			$this->type = $new_type;
		}

		/**
		 * Adds new or replaces old filter with same name
		 *
		 * @param string $name
		 * @param mixed $clause kMultipleFilter object or where clause ifself
		 * @access public
		 */
		function addFilter($name, $clause)
		{
			if( is_object($clause) && $clause->hasFilters() )
			{
				$this->filters[$name] = $clause->getSQL();
			}
			elseif( !is_object($clause) && strlen($clause) )
			{
				$this->filters[$name] = $clause;
			}
		}

		/**
		 * Returns filter by name
		 *
		 * @param string $name
		 * @return string
		 */
		function getFilter($name)
		{
			return isset($this->filters[$name]) ? $this->filters[$name] : false;
		}

		/**
		 * Removes specified filter from filters list
		 *
		 * @param string $name
		 * @access public
		 */
		function removeFilter($name)
		{
			unset($this->filters[$name]);
		}

		/**
		 * Remove all added filters
		 *
		 * @access public
		 */
		function clearFilters()
		{
			$this->filters = Array();
		}

		/**
		 * Build where clause based on added filters and multiple filter type
		 *
		 * @return string
		 * @access public
		 */
		function getSQL()
		{
			$filter_count = count($this->filters);
			if(!$filter_count) return '';

			return '('.implode(') '.$this->type.' (',$this->filters).')';
		}

		/**
		 * Allows to check if some filters are added to multiple filter
		 *
		 * @return bool
		 * @access public
		 */
		function hasFilters()
		{
			return $this->filters ? true : false;
		}

	}