<?php
/**
* @version	$Id: skins_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
	'Prefix'			=>	'skin',
	'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
	'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
	'EventHandlerClass'	=>	Array('class'=>'SkinEventHandler','file'=>'skin_eh.php','build_event'=>'OnBuild'),
	'TagProcessorClass' =>	Array('class'=>'kDBTagProcessor','file'=>'','build_event'=>'OnBuild'),

	'AutoLoad'			=>	true,
	'Hooks'				=>	Array(
		Array(
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'skin',
			'HookToSpecial' => '',
			'HookToEvent' => Array('OnSave'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnCompileStylesheet',
		),
	),
	'QueryString'		=>	Array(
		1	=>	'id',
		2	=>	'Page',
		3	=>	'event',
		4	=>	'mode',
	),
	'IDField'			=>	'SkinId',
	'StatusField'		=>	Array('IsPrimary'),
	'TableName'			=>	TABLE_PREFIX.'Skins',

/*
	'ForeignKey' => 'ParentId', // field title in TableName, linking record to a parent
	'ParentTableKey' => 'ParentId', // id (or other key) field title in parent's table
	'ParentPrefix' => 'parent',
	'AutoDelete' => true, // delete these items when parent is being deleted
	'AutoClone' => true, // clone these items when parent is being cloned
*/

	'TitlePresets'		=>	Array(
		'default'	=>	Array(
			'new_status_labels'		=> Array('skin'=>'!la_title_AddingSkin!'),
			'edit_status_labels'	=> Array('skin'=>'!la_title_EditingSkin!'),
			'new_titlefield'		=> Array('skin'=>''),
		),

		'skin_list'=>Array(
			'prefixes'				=> Array('skin_List'),
			'format'				=> '!la_tab_Skins!',
			'toolbar_buttons'		=> Array ('new_item', 'edit', 'delete', 'setprimary', 'clone', 'view', 'dbl-click'),
		),

		'skin_edit'=>Array(
			'prefixes'				=> Array('skin'),
			'format'				=> '#skin_status# #skin_titlefield#',
			'toolbar_buttons'		=> Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),
	),

	'PermSection'		=>	Array('main' => 'in-portal:skins'),

	// don't forget to add corresponding permissions to install script
	// INSERT INTO Permissions VALUES (0, 'custom:custom.view', 11, 1, 1, 0);
	// INSERT INTO Permissions VALUES (0, 'in-portal:skins.view', 11, 1, 1, 0), (0, 'in-portal:skins.add', 11, 1, 1, 0), (0, 'in-portal:skins.edit', 11, 1, 1, 0), (0, 'in-portal:skins.delete', 11, 1, 1, 0);
	'Sections'			=>	Array(
		'in-portal:skins'	=>	Array(
			'parent'		=>	'in-portal:tools',
			'icon'			=>	'admin_skins',
			'label'			=>	'la_tab_Skins',
			'url'			=>	Array('t' => 'skins/skin_list', 'pass' => 'm'),
			'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
			'priority'		=>	7,
//			'show_mode'		=>	smSUPER_ADMIN,
			'type'			=>	stTREE,
		),
	),

	'TitleField' =>	'Name',	// field, used in bluebar when editing existing item

	// Use %1$s for local table name with prefix, %2$s for calculated fields
	'ListSQLs' =>	Array(	// key - special, value - list select sql
		'' => 'SELECT %1$s.* %2$s
					 FROM %1$s',
	),
	'ItemSQLs' =>	Array(
		'' => 'SELECT %1$s.* %2$s
					 FROM %1$s',
	),
	'ListSortings'	=> 	Array(
		'' => Array(
//			'ForcedSorting' => Array('Priority' => 'desc'),
			'Sorting' => Array('Name' => 'asc'),
		)
	),
	'Fields' => Array (
		'SkinId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Name' => Array ('type' => 'string', 'max_len' => 255, 'required' => 1, 'default' => NULL),
		'CSS' => Array ('type' => 'string', 'default' => NULL),
		'Logo' => Array(
			'type'=>'string', 'formatter'=>'kUploadFormatter',
			'max_size'=>MAX_UPLOAD_SIZE, // in Bytes !
			'file_types'=>'*.jpg;*.gif;*.png', 'files_description'=>'!la_hint_ImageFiles!',
			'upload_dir' => WRITEBALE_BASE . '/user_files/', // relative to project's home
			'as_image'=>true, 'thumb_width'=>100, 'thumb_height'=>100,
			'multiple'=>false, // false or max number of files - will be stored as serialized array of paths
			'direct_links'=>false, // use direct file urls or send files through wrapper (requires mod_mime_magic)
			'default' => null,
		),
		'LogoBottom' => Array(
			'type'=>'string', 'formatter'=>'kUploadFormatter',
			'max_size'=>MAX_UPLOAD_SIZE, // in Bytes !
			'file_types'=>'*.jpg;*.gif;*.png', 'files_description'=>'!la_hint_ImageFiles!',
			'upload_dir' => WRITEBALE_BASE . '/user_files/', // relative to project's home
			'as_image'=>true, 'thumb_width'=>100, 'thumb_height'=>100,
			'multiple'=>false, // false or max number of files - will be stored as serialized array of paths
			'direct_links'=>false, // use direct file urls or send files through wrapper (requires mod_mime_magic)
			'not_null' => 1, 'default' => '',
		),
		'LogoLogin' => Array(
			'type'=>'string', 'formatter'=>'kUploadFormatter',
			'max_size'=>MAX_UPLOAD_SIZE, // in Bytes !
			'file_types'=>'*.jpg;*.gif;*.png', 'files_description'=>'!la_hint_ImageFiles!',
			'upload_dir' => WRITEBALE_BASE . '/user_files/', // relative to project's home
			'as_image'=>true, 'thumb_width'=>100, 'thumb_height'=>100,
			'multiple'=>false, // false or max number of files - will be stored as serialized array of paths
			'direct_links'=>false, // use direct file urls or send files through wrapper (requires mod_mime_magic)
			'not_null' => 1, 'default' => '',
		),
		'Options' => Array(
			'type' => 'string', 'default' => NULL,
			'formatter' => 'kSerializedFormatter',
			'default'=>serialize(
				array(
					'HeadBgColor' => array('Description'=>'Head frame background color', 'Value'=>'#1961B8'),
					'HeadColor' => array('Description'=>'Head frame text color', 'Value'=>'#000000'),
					'SectionBgColor' => array('Description'=>'Section bar background color', 'Value'=>'#2D79D6'),
					'SectionColor' => array('Description'=>'Section bar text color', 'Value'=>'#000000'),
				)
			),
		),
		'LastCompiled' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'IsPrimary' => Array(
			'type' => 'int', 'formatter' => 'kOptionsFormatter',
			'options' => Array(1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
	),

	'Grids'	=> Array(
		'Default'		=>	Array(
			'Icons' => Array(
				'default' => 'icon16_item.png',
				1 => 'icon16_primary.png',
			),
			'Fields' => Array(
				'SkinId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 50,  ),
				'Name' => Array( 'title'=>'la_col_SkinName', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
				'IsPrimary' => Array( 'title'=>'la_col_IsPrimary', 'filter_block' => 'grid_options_filter', 'width' => 100),
			),
		),
	),

	/*'ConfigMapping' => Array(
		'PerPage' => 'Comm_Perpage_Tests',
		'ShortListPerPage' => 'Comm_Perpage_Tests_Short',
	),*/
);