<?php

	class EmailMessageHelper extends kHelper {
	
		/**
		 * Extracts Subject, Headers, Body fields from email message translation
		 *
		 * @param string $text
		 * @return Array
		 */
		function parseTemplate($text)
		{
			$ret = Array ();
			$headers = Array();
			$lines = explode("\n", $text);

			foreach ($lines as $line) {
				if (strlen(trim($line)) == 0 || ($line == '.')) {
					break;
				}

				$parts = explode(':', $line, 2);
				if (strtolower($parts[0]) == 'subject') {
					$ret['Subject'] = trim($parts[1]);
				}
				else {
					$headers[] = $line;
				}
			}
			
			$ret['Headers'] = implode("\n", $headers);

			$message_body = '';
			while ((list($line_id,$line) = each($lines))) {
				$message_body .= $line;
			}
			
			$ret['Body'] = $message_body;
			
			return $ret;
		}
		
	}