function FrameResizer($show_title, $hide_title, $frameset, $save_url, open_width) {
	this.StatusIcon = {0: 'img/list_arrow_desc.gif', 1 : 'img/list_arrow_no.gif'};
	this.StatusText = {0: $hide_title, 1 : $show_title};
	this.StatusImage = document.getElementById('menu_toggle_img');
	this.StatusTextContainer = document.getElementById('menu_toggle_text');
	this.StatusLink = document.getElementById('menu_toggle_link');
	this.Frameset = $frameset;
	this.SaveURL = $save_url;
	this.OpenWidth = open_width ? open_width : 200;

	this.SubFrameset = $frameset.document.getElementById('sub_frameset');
	this.TopFrameset = $frameset.document.getElementById('top_frameset');
}

FrameResizer.prototype.InitControls = function ($instance) {
	this.StatusLink.onclick = function () {
		$instance.FrameToggle();
		return false;
	}
}

FrameResizer.prototype.MenuVisible = function () {
	return new RegExp('(.*)' + this.StatusIcon[0] + '$').exec(this.StatusImage.src) ? true : false;
}

FrameResizer.prototype.SetStatus = function ($status, $ajax_save) {
	this.StatusImage.src = this.StatusIcon[$status];
	this.StatusImage.alt = this.StatusLink.title = this.StatusTextContainer.innerHTML = this.StatusText[$status];
	document.getElementById('site_logo').style.display = $status ? 'none' : 'block';

	if ($ajax_save) {
		// save via ajax
		var $url = this.SaveURL.replace('#NAME#', 'ShowAdminMenu').replace('#VALUE#', $status);
		Request.makeRequest($url, false, '', this.successCallback, this.errorCallback, '', this);
	}
}

FrameResizer.prototype.successCallback = function($request, $params, $object) {
	/*var $responce = $request.responseText;
	var $match_redirect = new RegExp('^#redirect#(.*)').exec($responce);
	if ($match_redirect != null) {
		$object.showProgress(100);
		// redirect to external template requested
		window.location.href = $match_redirect[1];
		return false;
	}*/
}

FrameResizer.prototype.errorCallback = function($request, $params, $object) {
	alert('AJAX Error; class: FrameResizer; ' + Request.getErrorHtml($request));
}

FrameResizer.prototype.FrameToggle = function () {
	if (this.MenuVisible()) {
		this.setFullscreenMode(true, true);
	}
	else {
		this.setFullscreenMode(false, true);
	}
}

FrameResizer.prototype.setFullscreenMode = function ($full_screen, $ajax_save) {
	if ($full_screen) {
		this.TopFrameset.setAttribute('rows', '25,*');
		this.SubFrameset.setAttribute('cols', '0,*');
		this.SetStatus(1, $ajax_save);
	}
	else {
		this.TopFrameset.setAttribute('rows', this.Frameset.$top_height + ',*');
		this.SubFrameset.setAttribute('cols', this.OpenWidth+',*');
		this.SetStatus(0, $ajax_save);
	}
}

FrameResizer.prototype.fullScreen = function ($restore) {
	if ($restore === undefined) {
		$restore = false;
	}

	if (!$restore) {
		this.lastMenuVisible = this.MenuVisible();
	}

	this.setFullscreenMode($restore ? !this.lastMenuVisible : true, false);
}