<?php
/**
* @version	$Id: custom_fields_tag_processor.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class CustomFieldsTagProcessor extends kDBTagProcessor {

		/**
		 * Return LEFT JOINed custom field name from main item config
		 *
		 * @param Array $params
		 * @return string
		 */
		function GetMainField($params)
		{
			$object =& $this->getObject($params);
			$append = isset($params['append']) && $params['append'] ? $params['append'] : '';
			return 'cust_'.$object->GetDBField('FieldName').$append;
		}

		function CustomField($params)
		{
			$params['name'] = $this->GetMainField($params);
			$source_prefix = $this->Application->Parser->GetParam('SourcePrefix');
			return $this->Application->ProcessParsedTag($source_prefix, 'Field', $params);
		}

		function CustomFormat($params)
		{
			$params['name'] = $this->GetMainField($params);
			$source_prefix = $this->Application->Parser->GetParam('SourcePrefix');
			return $this->Application->ProcessParsedTag($source_prefix, 'Format', $params);
		}

		function CustomInputName($params)
		{
			$params['name'] = $this->GetMainField($params);
			$source_prefix = $this->Application->Parser->GetParam('SourcePrefix');
			return $this->Application->ProcessParsedTag($source_prefix, 'InputName', $params);
		}

		function setParamValue(&$params, $param_name)
		{
			// $deep_level if GetParam = 1 used in case if PrintList is called during parsing "grid" block (=> +1 to deep_level)
			if (!isset($params[$param_name])) {
				$params[$param_name] = $this->Application->Parser->GetParam($param_name, 1);
			}

			return $params[$param_name];
		}

		/**
		 * Prints list content using block specified
		 *
		 * @param Array $params
		 * @return string
		 * @access public
		 */
		function PrintList($params)
		{
			$this->setParamValue($params, 'SourcePrefix');
			$this->setParamValue($params, 'value_field');

			$list =& $this->GetList($params);
			$id_field = $this->Application->getUnitOption($this->Prefix,'IDField');

			$list->Query();
			$o = '';
			$list->GoFirst();

			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $this->SelectParam($params, 'render_as,block');
			$block_params['pass_params'] = 'true';

			$prev_heading = '';
			$display_original = false;
			$source_prefix = getArrayValue($params, 'SourcePrefix');
			if ($source_prefix) {
				$source_object =& $this->Application->recallObject($source_prefix, null, Array ('raise_warnings' => 0)); // it's possible, that in some cases object will not be loaded
				/* @var $source_object kCatDBItem */

				$display_original = $this->Application->ProcessParsedTag($source_prefix, 'DisplayOriginal', Array('display_original' => $this->setParamValue($params, 'display_original')));
			}

			if ($display_original) {
				$block_params['display_original'] = $display_original;
				$block_params['original_title'] = $this->setParamValue($params, 'original_title');
				$original_object =& $this->Application->recallObject($source_prefix.'.original', null, Array ('raise_warnings' => 0)); // it's possible, that in some cases object will not be loaded
			}

			if ($this->Special == 'general') {
				$this->groupRecords($list->Records, 'Heading');
			}

			$i = 0;
			while (!$list->EOL())
			{
				$block_params['is_last'] = ($i == $list->SelectedCount - 1);
				$block_params['not_last'] = !$block_params['is_last']; // for front-end

				$this->Application->SetVar( $this->getPrefixSpecial().'_id', $list->GetDBField($id_field) ); // for edit/delete links using GET

				if ($source_prefix) {
					$list->SetDBField($params['value_field'], $source_object->GetDBField('cust_'.$list->GetDBField('FieldName')));
					if ($display_original) {
						$list->SetDBField('OriginalValue', $original_object->GetField('cust_'.$list->GetDBField('FieldName')));
					}
					$block_params['field'] = $block_params['virtual_field'] = 'cust_'.$list->GetDBField('FieldName');
					$block_params['show_heading'] = ($prev_heading != $list->GetDBField('Heading') ) ? 1 : 0;

					$options = $source_object->GetFieldOptions('cust_'.$list->GetDBField('FieldName'));
					$list->SetDBField('DirectOptions', isset($options['options']) ? $options['options'] : false);
				}

				$o.= $this->Application->ParseBlock($block_params, 1);
				$prev_heading = $list->GetDBField('Heading');
				$list->GoNext();
				$i++;
			}

			$this->Application->SetVar( $this->getPrefixSpecial().'_id', '');
			return $o;
		}

		/**
		 * If data was modfied & is in TempTables mode, then parse block with name passed;
		 * remove modification mark if not in TempTables mode
		 *
		 * @param Array $params
		 * @return string
		 * @access public
		 * @author Alexey
		 */
		function SaveWarning($params)
		{
			$source_prefix = array_key_exists('SourcePrefix', $params) ? $params['SourcePrefix'] : false;
			if ($source_prefix && $source_prefix == 'c') {
				return $this->Application->ProcessParsedTag('c', 'SaveWarning', $params);
			}

			return parent::SaveWarning($params);
		}
	}