<?php
/**
* @version	$Id: groups_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config = Array (
		'Prefix' => 'g',

		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'GroupsEventHandler', 'file' => 'groups_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'GroupTagProcessor', 'file' => 'group_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'GroupId',
		'StatusField' => Array ('Enabled'),
		'TitleField' => 'Name',

		'SubItems' => Array ('g-perm', 'g-ug'),

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array('g' => '!la_title_Adding_Group!'),
				'edit_status_labels' => Array('g' => '!la_title_Editing_Group!'),
				'new_titlefield' => Array('g' => ''),
			),

			'group_list' => Array (
				'prefixes' => Array ('g.total_List'), 'format' => "!la_title_Groups!",
				'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'e-mail', 'view', 'dbl-click'),
				),

			'groups_edit' => Array (
				'prefixes' => Array ('g'), 'format' => "#g_status# '#g_titlefield#' - !la_title_General!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
				),

			'groups_edit_users' => Array (
				'prefixes' => Array ('g', 'g-ug_List'), 'format' => "#g_status# '#g_titlefield#' - !la_title_Users!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'select_user', 'delete', 'view'),
				),

			'groups_edit_permissions' => Array (
				'prefixes' => Array ('g'), 'format' => "#g_status# '#g_titlefield#' - !la_title_Permissions!",
				'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
				),

			'groups_edit_additional_permissions' => Array (
				'prefixes' => Array ('g'), 'format' => "#g_status# '#g_titlefield#' - !la_title_AdditionalPermissions!",
				'toolbar_buttons' => Array ('select', 'cancel'),
				),

			'select_group' => Array(
				'prefixes' => Array ('g.user_List'), 'format' => "!la_title_Groups! - !la_title_SelectGroup!",
				'toolbar_buttons' => Array ('select', 'cancel', 'view'),
				),
		),

		'EditTabPresets' => Array (
			'Default' => Array (
				'general' => Array ('title' => 'la_tab_General', 't' => 'groups/groups_edit', 'priority' => 1),
				'users' => Array ('title' => 'la_tab_Users', 't' => 'groups/groups_edit_users', 'priority' => 2),
				'permissions' => Array ('title' => 'la_tab_Permissions', 't' => 'groups/groups_edit_permissions', 'priority' => 3),
			),
		),

		'PermSection' => Array ('main' => 'in-portal:user_groups'),

		'TableName' => TABLE_PREFIX.'PortalGroup',

		'ListSQLs' => Array (
			'' => 'SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Name' => 'asc'),
			),
		),

		'CalculatedFields' => Array (
			'total' => Array (
				'UserCount' => 'SELECT COUNT(*) FROM ' . TABLE_PREFIX . 'UserGroup ug WHERE ug.GroupId = %1$s.GroupId',
			),
		),

		'Fields' => Array (
			'GroupId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Name' => Array ('type' => 'string', 'not_null' => 1, 'required' => 1, 'default' => ''),
			'Description' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => null),
			'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
			'System' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Personal' => Array ('type' => 'int','not_null' => 1, 'default' => 0),
			'Enabled' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'la_Enabled', 0 => 'la_Disabled'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
			'FrontRegistration' => Array (
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
				'not_null' => 1, 'default' => 0
			),
    	),

		'VirtualFields'	=> 	Array (
			'UserCount' => Array ('type' => 'int', 'default' => 0),
		),

		'Grids'	=> Array (
			'Default' => Array (
				'Icons' => Array (1 => 'icon16_item.png', 0 => 'icon16_disabled.png'),
				'Fields' => Array (
					'GroupId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
					'Name' => Array ('title' => 'la_col_GroupName', 'width' => 200, ),
					'UserCount' => Array ('title' => 'la_col_UserCount', 'filter_block' => 'grid_range_filter', 'width' => 100, ),
					'FrontRegistration' => Array ('title' => 'la_col_FrontRegistration', 'filter_block' => 'grid_options_filter', 'width' => 150, ),
				),
			),

			'UserGroups' => Array (
				'Icons' => Array (1 => 'icon16_item.png', 0 => 'icon16_disabled.png'),
				'Fields' => Array (
					'GroupId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
					'Name' => Array ('title' => 'la_col_GroupName', 'width' => 150, ),
				),
			),

			'Radio'	=>	Array (
				'Icons' => Array (1 => 'icon16_item.png', 0 => 'icon16_disabled.png'),
				'Selector' => 'radio',
				'Fields' => Array (
						'GroupId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
						'Name' => Array ('title' => 'la_col_GroupName', 'width' => 150, ),
						'Description' => Array ('title' => 'la_col_Description', 'width' => 250, ),
					),
			),

			'GroupSelector' => Array (
				'Icons' => Array (
					'default' => 'icon16_item.png',
					0 => 'icon16_disabled.png',
					1 => 'icon16_item.png',
				),
				'Fields' => Array (
						'GroupId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
						'Name' => Array ('title' => 'la_col_GroupName', 'width' => 150, ),
						'Description' => Array ('title' => 'la_col_Description', 'width' => 250, ),
					),
			),
		),
	);