<?php
/**
* @version	$Id: languages_item.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class LanguagesItem extends kDBItem
	{
		function generateID()
		{
			$sql = 'SELECT MAX('.$this->IDField.') FROM '.$this->Application->getUnitOption($this->Prefix, 'TableName');
			return $this->Conn->GetOne($sql) + 1;
		}

		function setPrimary($reset_primary = true, $admin_language = false)
		{
			$primary_field = $admin_language ? 'AdminInterfaceLang' : 'PrimaryLang';
			if ($reset_primary) {
				$sql = 'UPDATE '.$this->TableName.'
						SET '.$primary_field.' = 0';
				$this->Conn->Query($sql);
			}

			$sql = 'UPDATE '.$this->TableName.'
					SET '.$primary_field.' = 1, Enabled = 1
					WHERE '.$this->IDField.' = '.$this->GetID();
			$this->Conn->Query($sql);

			// in case, when Update method is called for this langauge object
			$this->SetDBField($primary_field, 1);
			$this->SetDBField('Enabled', 1);
		}

		/**
		 * Allows to format number according to regional settings
		 *
		 * @param float $number
		 * @param int $precision
		 * @return float
		 */
		function formatNumber($number, $precision = null)
		{
			if (is_null($precision)) {
				$precision = preg_match('/[\.,]+/', $number) ? strlen(preg_replace('/^.*[\.,]+/', '', $number)) : 0;
			}
			return number_format($number, $precision, $this->GetDBField('DecimalPoint'), $this->GetDBField('ThousandSep'));
		}

		function Load($id, $id_field_name=null)
		{
			$default = false;
			if ($id == 'default') {
				$id = 1;
				$id_field_name = 'PrimaryLang';
				$default = true;
			}

			$res = parent::Load($id, $id_field_name);

			if ($default) {
				if (!$res) {
					if ($this->Application->isAdmin) {
						$res = parent::Load(1);
					}
					else {
						if (defined('IS_INSTALL')) {
							// during first language import prevents sql errors
							$this->setID(1);
							$res = true;
						}
						else {
							$this->Application->ApplicationDie('No Primary Language Selected');
						}
					}
				}
				$this->Application->SetVar('lang.current_id', $this->GetID() );
				$this->Application->SetVar('m_lang', $this->GetID() );
			}
			return $res;
		}
	}