<?php
/**
* @version	$Id: user_profile_tp.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserProfileTagProcessor extends kDBTagProcessor {

		function Field($params)
		{
			$profile_mapping = $this->getProfileMapping();
			$field = $this->SelectParam($params, 'name,field');

			if (isset($params['profile_field']) && $params['profile_field']) {
				$params['name'] = $profile_mapping[$field];
				$value = $this->Application->ProcessParsedTag('u.profile', 'Field', $params);
			}
			else {
				$value = $this->recallUserProfileVar($field);
			}

			if (isset($params['checked']) && $params['checked']) {
				$checked_value = isset($params['value']) ? $params['value'] : 1;
				$value = ($value == $checked_value) ? 'checked' : '';
			}

			return $value;
		}

		/**
		 * Returns user_id to view profile from (same as u:getPassedID)
		 *
		 * @return int
		 */
		function getProfileUserID()
		{
			$profile_user_id = $this->Application->GetVar('user_id');
			if (!$profile_user_id) {
				// if none user_id given use current user id
				$profile_user_id = $this->Application->RecallVar('user_id');
			}

			return $profile_user_id;
		}

		/**
		 * Allows to get persistent var from other user
		 *
		 * @param int $user_id
		 * @param string $var_name
		 * @return mixed
		 */
		function recallUserProfileVar($var_name, $user_id = null)
		{
			static $cached_vars = null;

			if (!isset($cached_vars)) {
				if (!isset($user_id)) {
					$user_id = $this->getProfileUserID();
				}

				$sql = 'SELECT VariableValue, VariableName
						FROM '.TABLE_PREFIX.'PersistantSessionData
						WHERE (PortalUserId = '.$user_id.')';
				$cached_vars = $this->Conn->GetCol($sql, 'VariableName');
			}

			if (isset($cached_vars[$var_name])) {
				// get variable value from persistent session
				return $cached_vars[$var_name];
			}
			else {
				// not found in persistent session -> get default value from config variable with same name
				$config_value = $this->Application->ConfigValue($var_name);
				if ($config_value !== false) {
					return $config_value;
				}
			}

			return false;
		}

		/**
		 * Returns mapping between persistent var name and user profile field
		 *
		 * @return Array
		 */
		function getProfileMapping()
		{
			$profile_mapping = Array (
				'pp_firstname' => 'FirstName',
				'pp_lastname' => 'LastName',
				'pp_dob' => 'dob',
				'pp_email' => 'Email',
				'pp_phone' => 'Phone',
				'pp_street' => 'Street',
				'pp_city' => 'City',
				'pp_state' => 'State',
				'pp_zip' => 'Zip',
				'pp_country' => 'Country',
			);

			return $profile_mapping;
		}

		/**
		 * Returns visible field count in user profile
		 *
		 * @param Array $params
		 * @return int
		 */
		function ProfileFieldCount($params)
		{
			static $field_count = null;

			if (!isset($field_count)) {
				$profile_mapping = $this->getProfileMapping();
				$field_count = 0;
				foreach ($profile_mapping as $var_name => $field_name) {
					if ($this->recallUserProfileVar($var_name) == 1) {
						$field_count++;
					}
				}
			}

			return $field_count;
		}

		/**
		 * Allows to detect that not all fields were shown
		 *
		 * @param Array $params
		 * @return bool
		 */
		function NotLastField($params)
		{
			$counter = (int)$this->Application->GetVar($params['counter']);

			return $counter < $this->ProfileFieldCount();
		}

		/**
		 * Because of persistant session table doesn't have ids, we use user id as id for each record
		 *
		 * @param Array $params
		 * @return Array (id,field)
		 * @access private
		 */
		function prepareInputName($params)
		{
			list ($id, $field) = parent::prepareInputName($params);
			$id = $this->Application->RecallVar('user_id');

			return Array($id, $field);
		}

	}