<?php
/**
* @version	$Id: relationship_config.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

	$config =	Array(
					'Prefix'			=>	'rel',

					'Clones'			=>	Array(
												'c-rel'	=>	Array('ParentPrefix'	=>	'c'),
												'l-rel'	=>	Array('ParentPrefix'	=>	'l'),
												'n-rel'	=>	Array('ParentPrefix'	=>	'n'),
												'bb-rel'=>	Array('ParentPrefix'	=>	'bb'),
												/*'p-rel'	=>	Array('ParentPrefix'	=>	'p'),*/
												/*'cms-rel'=>	Array('ParentPrefix'	=>	'cms'),*/
											),

					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'RelationshipEventHandler','file'=>'relationship_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'RelationshipTagProcessor','file'=>'relationship_tp.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'Hooks'	=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => '#PARENT#',
													'HookToSpecial' => '*',
													'HookToEvent' => Array('OnAfterItemDelete'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnDeleteForeignRelations',
												),
											),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),
					'IDField'			=>	'RelationshipId',
					'StatusField'		=>	Array('Enabled','Type'),
					'TableName'			=>	TABLE_PREFIX.'Relationship',
					'ParentTableKey'=>	'ResourceId',
					'ForeignKey'	=>	'SourceId',
					'ParentPrefix'	=> 'p',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array('show_active','show_disabled'), 'type' => WHERE_FILTER),
													Array('mode' => 'AND', 'filters' => Array('show_recip','show_oneway'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array(
													'show_active'	=>	Array('label' =>'la_Active', 'on_sql' => '', 'off_sql' => 'Enabled != 1' ),
													'show_disabled'	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => 'Enabled != 0'  ),
													's1'	=>	Array(),
													'show_recip'	=>	Array('label' => 'la_Reciprocal', 'on_sql' => '', 'off_sql' => '%1$s.Type != 1'  ),
													'show_oneway'	=>	Array('label' => 'la_OneWay', 'on_sql' => '', 'off_sql' => '%1$s.Type != 2'  ),
												)
											),

					'CalculatedFields'	=>	Array(
												''	=>	Array(
															'ItemName'	=>	'TRIM(CONCAT(#ITEM_NAMES#))',
															'ItemType'	=>	'#ITEM_TYPES#',
														),
											),

					'ListSQLs'			=>	Array(	''=>	'SELECT %1$s.RelationshipId, %1$s.Priority, %1$s.Type, %1$s.Enabled %2$s
															 FROM %1$s #ITEM_JOIN#',
											), // key - special, value - list select sql

					'ListSortings'	=> 	Array(
																'' => Array(
																	'ForcedSorting' => Array('Priority' => 'desc'),
																	'Sorting' => Array('ItemName' => 'asc', 'ItemType' => 'asc'),
																)
															),
					'ItemSQLs'			=>	Array(	'' => 'SELECT %1$s.* %2$s FROM %1$s #ITEM_JOIN#',),

					'Fields'			=>	Array(
											    'RelationshipId'	=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
												'SourceId'			=>	Array('type'=>'int', 'required' => 1, 'default' => NULL),
												'TargetId'			=>	Array('type'=>'int', 'required' => 1, 'default' => NULL),
												'SourceType'		=>	Array('type'=>'int','not_null'=>1,'default'=>0),
												'TargetType'		=>	Array('type'=>'int','not_null'=>1,'default'=>0),
												'Type'				=>	Array('type'=>'int','formatter'=>'kOptionsFormatter', 'required' => 1, 'options'=>Array(1=>'la_Reciprocal',0=>'la_OneWay'), 'not_null'=>1,'default'=>0,'use_phrases'=>1),
												'Enabled'			=>	Array('type'=>'int','formatter'=>'kOptionsFormatter','options'=>Array(0=>'la_Disabled',1=>'la_Enabled'), 'not_null' => 1, 'default'=>1, 'use_phrases'=>1),
												'Priority'			=>	Array('type'=>'int','not_null'=>1,'default'=>0),
											),
					'VirtualFields'	=> 	Array(
												'ItemName' => Array(),
												'ItemType' => Array(),
										),

					'Grids'	=> Array(
								'Default'		=>	Array(
										'Icons' => Array(
											'default' => 'icon16_item.png',
											'1_0' => 'icon16_relation_one-way.gif',
											'0_0' => 'icon16_relation_one-way_disabled.gif',
											'1_1' => 'icon16_relation_reciprocal.gif',
											'0_1' => 'icon16_relation_reciprocal_disabled.gif'
										),	// icons for each StatusField values, if no matches or no statusfield selected, then "default" icon is used
										'Fields' => Array(
											'RelationshipId' => Array ('title' => 'la_col_Id', 'filter_block' => 'grid_range_filter', 'width' => 50, ),
											'ItemName' => Array( 'title'=>'la_col_TargetId', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter', 'width' => 200, ),
											'ItemType' => Array( 'title'=>'la_col_TargetType', 'filter_block' => 'grid_like_filter', 'width' => 80, ),
											'Type' => Array( 'title'=>'la_col_RelationshipType', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
											'Enabled' => Array( 'title'=>'la_col_Status', 'filter_block' => 'grid_options_filter', 'width' => 70, ),
										),
								),
						),
	);