<?php
/**
* @version	$Id: fck_helper.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class fckFCKHelper extends kHelper {

	var $Config = Array();

	function fckFCKHelper()
	{
		parent::kHelper();

		$this->Config['AllowedExtensions']['Files']	= array('jpg','gif','jpeg','png','swf','fla','jpg','gif','jpeg','png','avi','mpg','mpeg','zip','rar','arj','gz','tar','doc','pdf','ppt','rdp','swf','swt','txt','vsd','xls','csv','odt') ;
		$this->Config['DeniedExtensions']['Files']	= array('php','asp','aspx','ascx','jsp','cfm','cfc','pl','bat','exe','dll','reg') ;
		$this->Config['AllowedExtensions']['Images']	= array('jpg','gif','jpeg','png', 'bmp') ;
		$this->Config['DeniedExtensions']['Images']	= array('php','asp','aspx','ascx','jsp','cfm','cfc','pl','bat','exe','dll','reg');
		$this->Config['AllowedExtensions']['Flash']	= array('swf','fla') ;
		$this->Config['DeniedExtensions']['Flash']	= array('php','asp','aspx','ascx','jsp','cfm','cfc','pl','bat','exe','dll','reg') ;
		$this->Config['AllowedExtensions']['Media']	= array('asf','asx','avi','wav','wax','wma','wm','wmv','m3u','mp2v','mpg','mpeg','m1v','mp2','mp3','mpa','mpe','mpv2','mp4','mid','midi','rmi','qt','aif','aifc','aiff','mov','flv','rm','svcd','swf','vcd') ;
		$this->Config['DeniedExtensions']['Media']	= array('php','asp','aspx','ascx','jsp','cfm','cfc','pl','bat','exe','dll','reg');
		$this->Config['AllowedExtensions']['Documents']	= array('doc','pdf','ppt','rdp','swf','swt','txt','vsd','xls','csv','zip','odt') ;
		$this->Config['DeniedExtensions']['Documents']	= array('php','asp','aspx','ascx','jsp','cfm','cfc','pl','bat','exe','dll','reg');

	}

	function CreateFolder($folder = '')
	{
		if (!$folder) {
			return false;
		}

		$folderPath = WRITEABLE . '/user_files/' . $folder;

		if (file_exists($folderPath) && is_dir($folderPath)) {
			return true;
		}

		$permissions = defined('FCK_FOLDERS_PERMISSIONS') ? FCK_FOLDERS_PERMISSIONS : '0777';
		return mkdir($folderPath); // , $permissions
	}

	function IsAllowedExtension($folder, $file_name)
	{
		$base_folder = $this->getBaseFolder($folder);
		eregi("(\.[a-zA-Z0-9]{1,10})$", $file_name, $regs);
		$ext = strtolower(ltrim($regs[1],"."));
		if (isset($this->Config['DeniedExtensions'][$folder])) {
			if (in_array($ext, $this->Config['DeniedExtensions'][$folder])) {
				return false;
			}
		}
		if (isset($this->Config['AllowedExtensions'][$folder])) {
			if (!in_array($ext, $this->Config['AllowedExtensions'][$folder])) {
				return false;
			}
		}
		return true;
	}

	function getBaseFolder($folder)
	{
		$end = strpos("/", $folder);
		if ($end) {
			return substr($folder, 0, $end);
		}
		return $folder;
	}

	function ReadFolders($files_dir)
	{
		$aFolders = array();
		$oCurrentFolder = opendir($files_dir) ;
		$KernelSystemFolders = defined('KERNEL_SYSTEM_FOLDERS') ? KERNEL_SYSTEM_FOLDERS : array('icons', 'CVS', '.svn');
		while ( $sFile = readdir( $oCurrentFolder ) )
		{
			if (is_dir($files_dir . $sFile ) && !in_array($sFile,$KernelSystemFolders) && $sFile != '.' && $sFile != '..') {
				$aFolders[] = $sFile;
			}
		}
		closedir( $oCurrentFolder ) ;
		return $aFolders;
	}


	function ReadFiles($files_dir)
	{
		$aFiles = array();
		$oCurrentFolder = opendir($files_dir) ;
		while ( $sFile = readdir( $oCurrentFolder ) )
		{
			if (!is_dir($files_dir . $sFile )) {
				$aFiles[] = $sFile;
			}
		}
		closedir( $oCurrentFolder ) ;
		return $aFiles;
	}


	function PrintFolders()
	{
		$order_by = $this->Application->GetVar('order_by');
		$sort_by = $this->Application->GetVar('sort_by');
		$folder = $this->Application->GetVar('folder');
		$files_dir = WRITEABLE."/user_files/".$folder."/";
		$aFolders = $this->ReadFolders($files_dir);
		$ret = '';
		$order_by = $this->Application->GetVar('order_by');
		$sort_by = $this->Application->GetVar('sort_by');
		natcasesort($aFolders);
		foreach ($aFolders as $k => $v) {
			$ret .= '<folder2 path="'.$folder."/".$v.'">'.$v.'</folder2>'."\n";
		}

		if ($sort_by == 'name' && $order_by == '_desc') {
			$aFolders = array_reverse($aFolders);
		}
		foreach ($aFolders as $k => $v) {
			$ret .= '<folder path="'.$folder."/".$v.'">'.$v.'</folder>'."\n";
		}
		return $ret;
	}

	function CalculateFileSize($size)
	{
		if ( $size > 0 ) {
			$size = round( $size / 1024 );
			$size = ($size < 1)? 1:$size;//  round( $iFileSize / 1024 ) ;
		}
		return $size;
	}

	function CheckIconType($v)
	{
		$a_ext = Array('ai','avi','bmp','cs','dll','doc','exe','fla','gif','htm','html','jpg','js','mdb','mp3','pdf','png','ppt','rdp','swf','swt','txt','vsd','xls','xml','zip');

		eregi("(\.[a-zA-Z0-9]{1,10})$", $v, $regs);
		$ext = strtolower(ltrim($regs[1],"."));
		if (in_array($ext, $a_ext))
		{
			$icon = $ext;
		} else {
			$icon = 'default.icon';
		}
		return $icon;
	}

	function GetXmlString($size,$url,$icon,$date,$file_name)
	{
		return 	'<file size="'.$size.'" url="'.$url.'" icon="'.$icon.'" date="'.$date.'">'.$file_name.'</file>'."\n";
	}

	function PrintFiles()
	{
		$order_by = $this->Application->GetVar('order_by');
		$sort_by = $this->Application->GetVar('sort_by');

		$folder = $this->Application->GetVar('folder');
		$files_dir = WRITEABLE . "/user_files/" . $folder."/";
		$files_url = BASE_PATH . WRITEBALE_BASE . "/user_files/" . $folder . "/";
		$aFiles = $this->ReadFiles($files_dir);
		$ret = '';
		$date_format = "m/d/Y h:i A";
		natcasesort($aFiles);
		if ($sort_by == 'name' && $order_by == '_desc') {
			$aFiles = array_reverse($aFiles,TRUE);
		}

		foreach ($aFiles as $k => $v)
		{
			$aFilesSize[$k] = filesize( $files_dir . $v);
			$aFilesDate[$k] = filectime( $files_dir . $v);
		}
		if ($sort_by == 'name') {
			foreach ($aFiles as $k => $file) {
				$size = $this->CalculateFileSize($aFilesSize[$k]);
				$date = date($date_format, $aFilesDate[$k]);
				$icon = $this->CheckIconType($file);
				$ret .= $this->GetXmlString($size,$files_url.$file,$icon,$date,$file);
			}
		}
		if ($sort_by == 'date') {
			asort($aFilesDate);
			 if($order_by == '_desc') {
			 	$aFilesDate = array_reverse($aFilesDate,TRUE);
			 }
			foreach ($aFilesDate as $k => $date) {
				$size = $this->CalculateFileSize($aFilesSize[$k]);
				$file = $aFiles[$k];
				$date = date($date_format, $date);
				$icon = $this->CheckIconType($file);
				$ret .= $this->GetXmlString($size,$files_url.$file,$icon,$date,$file);
			}
		}
		if ($sort_by == 'size') {
			asort($aFilesSize);
			 if($order_by == '_desc') {
			 	$aFilesSize = array_reverse($aFilesSize,TRUE);
			 }
			foreach ($aFilesSize as $k => $size) {
				$size = $this->CalculateFileSize($size);
				$file = $aFiles[$k];
				$date = date($date_format, $aFilesDate[$k]);
				$icon = $this->CheckIconType($file);
				$ret .= $this->GetXmlString($size,$files_url.$file,$icon,$date,$file);
			}
		}
		return $ret;
	}

	function UploadFile()
	{
		$Extensions['Allowed']['Files']	= array('jpg','gif','jpeg','png','swf','fla','jpg','gif','jpeg','png','avi','mpg','mpeg','zip','rar','arj','gz','tar','doc','pdf','ppt','rdp','swf','swt','txt','vsd','xls','csv','odt') ;
		$Extensions['Allowed']['Images'] = array('jpg','gif','jpeg','png', 'bmp') ;
		$Extensions['Allowed']['Flash']	= array('swf','fla') ;
		$Extensions['Allowed']['Media']	= array('asf','asx','avi','wav','wax','wma','wm','wmv','m3u','mp2v','mpg','mpeg','m1v','mp2','mp3','mpa','mpe','mpv2','mp4','mid','midi','rmi','qt','aif','aifc','aiff','mov','flv','rm','svcd','swf','vcd') ;
		$Extensions['Allowed']['Documents']	= array('doc','pdf','ppt','rdp','swf','swt','txt','vsd','xls','csv','zip','odt') ;

		$upload_dir = $this->Application->GetVar('upload_dir');
		$type = explode("/",$upload_dir);
		$type = $type[0];
		$sServerDir =  WRITEABLE."/user_files/".$upload_dir."/";

		$aUpFile = $_FILES['NewFile'];
		$sFileName = $aUpFile['name'];
		$sOriginalFileName = $aUpFile['name'];
		$sExtension = strtolower(substr( $sFileName, ( strrpos($sFileName, '.') + 1 ) ) );
		$sErrorNumber = 0;
		if ( isset( $_FILES['NewFile'] ) && !is_null( $_FILES['NewFile']['tmp_name'] ) )
		{
			if (in_array($sExtension,$Extensions['Allowed'][$type]))
			{

				if (!$aUpFile['error']) {
					$iCounter = 0 ;
					while ( true )
					{
						$sFilePath = $sServerDir . $sFileName ;
						if ( is_file( $sFilePath ) )
						{
							$iCounter++ ;
							$sFileName = $this->RemoveExtension( $sOriginalFileName ) . '(' . $iCounter . ').' . $sExtension ;
							$sErrorNumber = '201' ;
						}
						else
						{
							// Turn off all error reporting.
							error_reporting( 0 ) ;
							// Enable error tracking to catch the error.
							ini_set( 'track_errors', '1' ) ;
							move_uploaded_file( $aUpFile['tmp_name'], $sFilePath ) ;
							$sErrorMsg = $php_errormsg ;
							// Restore the configurations.
							ini_restore( 'track_errors' ) ;
							ini_restore( 'error_reporting' ) ;

							if ( is_file( $sFilePath ) )
							{
								$oldumask = umask(0) ;
								chmod( $sFilePath, 0666 ) ;
								umask( $oldumask ) ;
							}
							break ;
						}
					}
				}
			} else {
				$sErrorNumber = '203';
			}
		} else {
			$sErrorNumber = '202' ;
		}
		echo '<script type="text/javascript">' ;
		echo 'window.parent.frames["frmUpload"].OnUploadCompleted(' . $sErrorNumber . ',"' . str_replace( '"', '\\"', $sFileName ) . '") ;' ;
		echo '</script>' ;
	}

	function RemoveExtension( $fileName )
	{
		return substr( $fileName, 0, strrpos( $fileName, '.' ) ) ;
	}
}