<?php
/**
* @version	$Id: fck_tp.php 12734 2009-10-20 19:28:11Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class FckTagProcessor extends  kDBTagProcessor {


		function ReadFolders($files_dir)
		{
			$folders = glob($files_dir . '*', GLOB_ONLYDIR);
			if (!$folders) {
				return Array ();
			}

			$folders = array_map('basename', $folders);
			$system_folders = defined('KERNEL_SYSTEM_FOLDERS') ? KERNEL_SYSTEM_FOLDERS : Array ('icons', 'CVS', '.svn');

			return array_diff($folders, $system_folders);
		}

		function ReadFiles($files_dir)
		{
			$aFiles = array();
			$oCurrentFolder = opendir($files_dir) ;
//			$KernelSystemFolders = defined('KERNEL_SYSTEM_FOLDERS') ? KERNEL_SYSTEM_FOLDERS : array('icons', 'CVS', '.svn');
			while ( $sFile = readdir( $oCurrentFolder ) )
			{
				if (!is_dir($files_dir . $sFile )) {
					$aFiles[] = $sFile;
				}
			}
			closedir( $oCurrentFolder ) ;
			return $aFiles;
		}

		function CheckCreateDefaultFolders()
		{
			$fck_helper =& $this->Application->recallObject('FCKHelper');
			/* @var fck_helper fckFCKHelper*/

			$default_folders = defined('FCK_DEFAULT_FOLDERS') ? FCK_DEFAULT_FOLDERS : Array ('Files', 'Images', 'Flash', 'Documents');

			foreach ($default_folders as $index => $folder) {
				if (!$fck_helper->CreateFolder($folder)) {
					unset($default_folders[$index]);
				}
			}

			if (!$default_folders) {
				return '';
			}

			$ret = '';
			foreach ($default_folders as $folder) {
				$selected = ($this->Application->GetVar('type') == $folder) ? 'selected' : '';
				$ret.=  '<option value="' . $folder . '" '.$selected.' />' . $folder;
			}

			return $ret;
		}

		function PrintFolders($params)
		{
			$order_by = $this->Application->GetVar('order_by');
			$sort_by = $this->Application->GetVar('sort_by');
			$params['folder'] = $this->Application->GetVar('folder');
			$files_dir = WRITEABLE."/user_files/".$params['folder']."/";
			$aFolders = $this->ReadFolders($files_dir);
			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $block_params['render_as'];
			$ret = '';
			foreach ($aFolders as $k => $v) {
				$block_params['folder_name'] = $v;
				$block_params['path'] = $params['folder']."/".$v;
				$ret .= $this->Application->ParseBlock($block_params);
			}
			return $ret;
		}

		function PrintFiles($params)
		{
			$params['folder'] = $this->Application->GetVar('folder');
			$files_dir = WRITEABLE . "/user_files/" . $params['folder'] . "/";
			$files_url = BASE_PATH . WRITEBALE_BASE . "/user_files/" . $params['folder']."/";
			$aFiles = $this->ReadFiles($files_dir);
			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $block_params['render_as'];
			$ret = '';
			$date_format = "m/d/Y h:i A";
			$a_ext = Array('ai','avi','bmp','cs','dll','doc','exe','fla','gif','htm','html','jpg','js','mdb','mp3','pdf','png','ppt','rdp','swf','swt','txt','vsd','xls','xml','zip');
			foreach ($aFiles as $k => $v) {
				$size = filesize( $files_dir . $v ) ;
				if ( $size > 0 ) {
					$size = round( $size / 1024 );
					$size = ($size < 1)? 1:$size;//  round( $iFileSize / 1024 ) ;
				}

				eregi("(\.[a-zA-Z0-9]{1,10})$", $v, $regs);
				$ext = strtolower(ltrim($regs[1],"."));
				if (in_array($ext, $a_ext))
				{
					$icon = $ext;
				} else {
					$icon = 'default.icon';
				}

				$block_params['file_name'] = $v;
				$block_params['size'] = $size;
				$block_params['url'] = $files_url.$v;
				$block_params['icon'] = $icon;
				$block_params['date'] = date($date_format, filectime( $files_dir . $v ));
//				$block_params['path'] = $params['folder']."/".$v;
				$ret .= $this->Application->ParseBlock($block_params);
			}
			return $ret;
		}
	}