$(document).ready(function(){


	// List item helpers
	$("ul li:first-child").addClass("first-child");
	$("ul li:last-child").addClass("last-child");

	// Border on hover of menu items
	$("#nav li a, #nav-sec li a, #site-info li a").append("<div></div>");
	// Remove from second level
	$("#nav li li a div").remove();

	// Javascript Document
	$("html").addClass("js");

	// Rounded Corners
//	$('div.block').prepend('<div class="round-top"></div>');
//	$('div.block').append('<div class="round-bottom"></div>');

	// Menu Hovers for IE6
	$("#nav li").hover(
		function() {
			$(this).addClass("hover");
		}, function() {
			$(this).removeClass("hover");
		}
	);
	$("#nav li:first-child").hover(
		function() {
			$(this).addClass("first-child-hover");
		}, function() {
			$(this).removeClass("first-child-hover");
		}
	);

	/* Text Resize
	--------------------- */
	// Insert resize links
	$('ul#content-tools').prepend('<li id="print-version"><a href="#print-version">Click me to print</a></li>');
	$('ul#content-tools li#print-version a').click(function() {
		window.print();
		return false;
	});
	$('ul#content-tools').prepend('<li id="text-size"><a href="#" title="Decrease Text Size" id="text-decrease">Decrease Text Size</a> <a href="#" title="Increase Text Size" id="text-increase">Increase Text Size</a></li>');

	// Have we got a cookie?
	savedFontSize = $.cookie('fontSize');
	if (savedFontSize != null) {
		$('body').css('font-size', savedFontSize);
	}
	else {
		$('body').css('font-size', "12px");
	}
	// Increase Font Size
	$("a#text-increase").click(function(){
	var currentFontSize = $('body').css('font-size');
	var currentFontSizeNum = parseFloat(currentFontSize, 10);
	var newFontSize = currentFontSizeNum+1;
	if (currentFontSizeNum < 18) {
		$('body').css('font-size', newFontSize);
		// Set Cookie
		$.cookie('fontSize', newFontSize+'px');
	}
	return false;
	});
	// Decrease Font Size
	$("a#text-decrease").click(function(){
	var currentFontSize = $('body').css('font-size');
	var currentFontSizeNum = parseFloat(currentFontSize, 10);
	var newFontSize = currentFontSizeNum-1;
	if (currentFontSizeNum > 8) {
		$('body').css('font-size', newFontSize);
		// Set Cookie
		$.cookie('fontSize', newFontSize+'px');
	}
	return false;
	});

});