<?php
/**
* @version	$Id: user_profile_eh.php 12299 2009-08-17 01:51:27Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class UserProfileEventHandler extends kDBEventHandler {

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{
			parent::mapPermissions();
			$permissions = Array (
				'OnItemBuild'	=>	Array('subitem' => true),
				'OnUpdate'	=>	Array('subitem' => true),
			);

			$this->permMapping = array_merge($this->permMapping, $permissions);
		}

		/**
		 * Saves user profile to database
		 *
		 * @param kEvent $event
		 */
		function OnUpdate(&$event)
		{
			$items_info = $this->Application->GetVar($event->getPrefixSpecial(true));
			list ($user_id, $field_values) = each($items_info);

			if ($user_id != $this->Application->RecallVar('user_id')) {
				// we are not updating own profile
				return ;
			}

			foreach ($field_values as $variable_name => $variable_value) {
				$this->Application->StorePersistentVar($variable_name, unhtmlentities($variable_value));
			}
		}

	}