<?php
/**
* @version	$Id: unit_formatter.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class kUnitFormatter extends kFormatter {

	function PrepareOptions($field_name, &$field_options, &$object)
	{
		if( !isset($field_options['master_field']) )
		{
			$regional =& $this->Application->recallObject('lang.current');
			$add_fields = Array();
			$options_a =  Array('type' => 'int','error_field' => $field_name,'master_field' => $field_name,'format' => '%d' );
			$options_b =  Array('type' => 'double','error_field' => $field_name,'master_field' => $field_name,'format' => '%0.2f' );
			switch( $regional->GetDBField('UnitSystem') )
			{
				case 2: // US/UK
					$field_options_copy = $field_options;
					unset($field_options_copy['min_value_exc']);
					$add_fields[$field_name.'_a'] = array_merge_recursive2($field_options_copy, $options_a);
					$add_fields[$field_name.'_b'] = array_merge_recursive2($field_options_copy, $options_b);
				break;
				default:
			}
			$add_fields = array_merge_recursive2($add_fields, $object->VirtualFields);
			$object->setVirtualFields($add_fields);
		}
	}

	function UpdateMasterFields($field, $value, &$options, &$object)
	{
		if( !isset($options['master_field']) )
		{
			if ($value == -1) return; // for infinity setting, otherwise infinity is incorrectly converted back to Kg
			$regional =& $this->Application->recallObject('lang.current');
			switch( $regional->GetDBField('UnitSystem') )
			{
				case 2: // US/UK
					$major = $this->TypeCast($object->GetDBField($field.'_a'), $options);
					$minor = $this->TypeCast($object->GetDBField($field.'_b'), $options);
					if($major === '' && $minor === '')
					{
						$value = null;
					}
					elseif($major === null && $minor === null)
					{
						unset($object->Fields[$field]);
						return;
					}
					else
					{
						$value = Pounds2Kg($major, $minor);
					}
				break;
				default:
			}
			$object->SetDBField($field, $value);
		}
	}

	function UpdateSubFields($field, $value, &$options, &$object)
	{
		if( !isset($options['master_field']) )
		{
			$regional =& $this->Application->recallObject('lang.current');
			switch( $regional->GetDBField('UnitSystem') )
			{
				case 2: // US/UK
					if($value === null)
					{
						$major = null;
						$minor = null;
					}
					else
					{
						list($major,$minor) = Kg2Pounds($value);
						/*$major = floor( $value / 0.5 );
						$minor = ($value - $major * 0.5) * 32;*/
					}
					$object->SetDBField($field.'_a', $major);
					$object->SetDBField($field.'_b', $minor);
				break;
				default:
			}
		}
	}
}