CREATE TABLE PermissionConfig (
  PermissionConfigId int(11) NOT NULL auto_increment,
  PermissionName varchar(30) NOT NULL default '',
  Description varchar(255) NOT NULL default '',
  ErrorMessage varchar(255) NOT NULL default '',
  ModuleId varchar(20) NOT NULL default '0',
  PRIMARY KEY  (PermissionConfigId),
  KEY PermissionName (PermissionName)
);

CREATE TABLE Permissions (
  PermissionId int(11) NOT NULL auto_increment,
  Permission varchar(255) NOT NULL default '',
  GroupId int(11) default '0',
  PermissionValue int(11) NOT NULL default '0',
  `Type` tinyint(4) NOT NULL default '0',
  CatId int(11) NOT NULL default '0',
  PRIMARY KEY  (PermissionId),
  UNIQUE KEY PermIndex (Permission,GroupId,CatId,`Type`)
);

CREATE TABLE CustomField (
  CustomFieldId int(11) NOT NULL auto_increment,
  `Type` int(11) NOT NULL default '0',
  FieldName varchar(255) NOT NULL default '',
  FieldLabel varchar(40) default NULL,
  MultiLingual tinyint(3) unsigned NOT NULL default '1',
  Heading varchar(60) default NULL,
  Prompt varchar(60) default NULL,
  ElementType varchar(50) NOT NULL default '',
  ValueList text,
  DefaultValue varchar(255) NOT NULL default '',
  DisplayOrder int(11) NOT NULL default '0',
  OnGeneralTab tinyint(4) NOT NULL default '0',
  IsSystem tinyint(3) unsigned NOT NULL default '0',
  IsRequired tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (CustomFieldId),
  KEY `Type` (`Type`),
  KEY MultiLingual (MultiLingual),
  KEY DisplayOrder (DisplayOrder),
  KEY OnGeneralTab (OnGeneralTab),
  KEY IsSystem (IsSystem),
  KEY DefaultValue (DefaultValue)
);

CREATE TABLE ConfigurationAdmin (
  VariableName varchar(80) NOT NULL default '',
  heading varchar(255) default NULL,
  prompt varchar(255) default NULL,
  element_type varchar(20) NOT NULL default '',
  Validation text,
  ValueList text,
  DisplayOrder double NOT NULL default '0',
  GroupDisplayOrder double NOT NULL default '0',
  Install int(11) NOT NULL default '1',
  PRIMARY KEY  (VariableName),
  KEY DisplayOrder (DisplayOrder),
  KEY GroupDisplayOrder (GroupDisplayOrder),
  KEY Install (Install)
);

CREATE TABLE ConfigurationValues (
  VariableId int(11) NOT NULL auto_increment,
  VariableName varchar(255) NOT NULL default '',
  VariableValue text,
  ModuleOwner varchar(20) default 'In-Portal',
  Section varchar(255) NOT NULL default '',
  PRIMARY KEY  (VariableId),
  UNIQUE KEY VariableName (VariableName)
);

CREATE TABLE EmailMessage (
  EmailMessageId int(10) NOT NULL auto_increment,
  Template longtext,
  MessageType enum('html','text') NOT NULL default 'text',
  LanguageId int(11) NOT NULL default '0',
  EventId int(11) NOT NULL default '0',
  `Subject` text,
  PRIMARY KEY  (EmailMessageId)
);

CREATE TABLE EmailQueue (
  EmailQueueId int(10) unsigned NOT NULL auto_increment,
  ToEmail varchar(255) NOT NULL default '',
  `Subject` varchar(255) NOT NULL default '',
  MessageHeaders text,
  MessageBody longtext,
  Queued int(10) unsigned NOT NULL default '0',
  SendRetries int(10) unsigned NOT NULL default '0',
  LastSendRetry int(10) unsigned NOT NULL default '0',
  MailingId int(10) unsigned NOT NULL,
  PRIMARY KEY  (EmailQueueId),
  KEY LastSendRetry (LastSendRetry),
  KEY SendRetries (SendRetries),
  KEY MailingId (MailingId)
);

CREATE TABLE EmailSubscribers (
  EmailMessageId int(11) NOT NULL default '0',
  PortalUserId int(11) NOT NULL default '0',
  KEY EmailMessageId (EmailMessageId),
  KEY PortalUserId (PortalUserId)
);

CREATE TABLE Events (
  EventId int(11) NOT NULL auto_increment,
  Event varchar(40) NOT NULL default '',
  ReplacementTags text,
  Enabled int(11) NOT NULL default '1',
  FrontEndOnly tinyint(3) unsigned NOT NULL default '0',
  FromUserId int(11) default NULL,
  Module varchar(40) NOT NULL default '',
  Description varchar(255) NOT NULL default '',
  `Type` int(11) NOT NULL default '0',
  PRIMARY KEY  (EventId),
  KEY `Type` (`Type`),
  KEY Enabled (Enabled),
  KEY Event (Event),
  KEY FrontEndOnly (FrontEndOnly)
);

CREATE TABLE IdGenerator (
  lastid int(11) default NULL
);

CREATE TABLE Language (
  LanguageId int(11) NOT NULL auto_increment,
  PackName varchar(40) NOT NULL default '',
  LocalName varchar(40) NOT NULL default '',
  Enabled int(11) NOT NULL default '1',
  PrimaryLang int(11) NOT NULL default '0',
  AdminInterfaceLang tinyint(3) unsigned NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  IconURL varchar(255) default NULL,
  IconDisabledURL varchar(255) default NULL,
  DateFormat varchar(50) NOT NULL default '',
  TimeFormat varchar(50) NOT NULL default '',
  InputDateFormat varchar(50) NOT NULL default 'm/d/Y',
  InputTimeFormat varchar(50) NOT NULL default 'g:i:s A',
  DecimalPoint varchar(10) NOT NULL default '',
  ThousandSep varchar(10) NOT NULL default '',
  `Charset` varchar(20) NOT NULL default '',
  UnitSystem tinyint(4) NOT NULL default '1',
  FilenameReplacements text,
  Locale varchar(10) NOT NULL default 'en-US',
  UserDocsUrl varchar(255) NOT NULL,
  PRIMARY KEY  (LanguageId),
  KEY Enabled (Enabled),
  KEY PrimaryLang (PrimaryLang),
  KEY AdminInterfaceLang (AdminInterfaceLang),
  KEY Priority (Priority)
);

CREATE TABLE Modules (
  `Name` varchar(255) NOT NULL default '',
  Path varchar(255) NOT NULL default '',
  `Var` VARCHAR(100) NOT NULL DEFAULT '',
  Version varchar(10) NOT NULL default '0.0.0',
  Loaded tinyint(4) NOT NULL default '1',
  LoadOrder tinyint(4) NOT NULL default '0',
  TemplatePath varchar(255) NOT NULL default '',
  RootCat int(11) NOT NULL default '0',
  BuildDate int(10) unsigned default NULL,
  PRIMARY KEY  (`Name`),
  KEY Loaded (Loaded),
  KEY LoadOrder (LoadOrder)
);

CREATE TABLE PersistantSessionData (
  VariableId bigint(20) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  VariableName varchar(255) NOT NULL default '',
  VariableValue text NOT NULL,
  PRIMARY KEY (VariableId),
  KEY UserId (PortalUserId),
  KEY VariableName (VariableName)
);

CREATE TABLE Phrase (
  Phrase varchar(255) NOT NULL DEFAULT '',
  PhraseKey varchar(255) NOT NULL,
  Translation text NOT NULL,
  PhraseType int(11) NOT NULL DEFAULT '0',
  PhraseId int(11) NOT NULL AUTO_INCREMENT,
  LanguageId int(11) NOT NULL DEFAULT '0',
  LastChanged int(10) unsigned NOT NULL DEFAULT '0',
  LastChangeIP varchar(15) NOT NULL DEFAULT '',
  Module varchar(30) NOT NULL DEFAULT 'In-Portal',
  PRIMARY KEY (PhraseId),
  UNIQUE KEY LanguageId_2 (LanguageId,Phrase),
  KEY LanguageId (LanguageId),
  KEY Phrase_Index (Phrase),
  KEY PhraseKey (PhraseKey)
);

CREATE TABLE PhraseCache (
  Template varchar(40) NOT NULL default '',
  PhraseList text NOT NULL,
  CacheDate int(11) NOT NULL default '0',
  ThemeId int(11) NOT NULL default '0',
  StylesheetId int(10) unsigned NOT NULL default '0',
  ConfigVariables text,
  PRIMARY KEY  (Template),
  KEY CacheDate (CacheDate),
  KEY ThemeId (ThemeId),
  KEY StylesheetId (StylesheetId)
);

CREATE TABLE PortalGroup (
  GroupId int(11) NOT NULL auto_increment,
  Name varchar(255) NOT NULL default '',
  Description varchar(255) default NULL,
  CreatedOn int(10) unsigned default NULL,
  System tinyint(4) NOT NULL default '0',
  Personal tinyint(4) NOT NULL default '0',
  Enabled tinyint(4) NOT NULL default '1',
  ResourceId int(11) NOT NULL default '0',
  FrontRegistration tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (GroupId),
  UNIQUE KEY Name (Name),
  UNIQUE KEY ResourceId (ResourceId),
  KEY Personal (Personal),
  KEY Enabled (Enabled),
  KEY CreatedOn (CreatedOn)
);

CREATE TABLE PortalUser (
  PortalUserId int(11) NOT NULL auto_increment,
  Login varchar(255) default NULL,
  `Password` VARCHAR(255) NULL DEFAULT 'd41d8cd98f00b204e9800998ecf8427e',
  FirstName VARCHAR(255) NOT NULL DEFAULT '',
  LastName VARCHAR(255) NOT NULL DEFAULT '',
  Company varchar(255) NOT NULL default '',
  Email varchar(255) NOT NULL default '',
  CreatedOn INT DEFAULT NULL,
  Phone varchar(20) default NULL,
  Fax varchar(255) NOT NULL default '',
  Street varchar(255) default NULL,
  Street2 varchar(255) NOT NULL default '',
  City varchar(20) default NULL,
  State varchar(20) NOT NULL default '',
  Zip varchar(20) default NULL,
  Country varchar(20) NOT NULL default '',
  ResourceId int(11) NOT NULL default '0',
  `Status` tinyint(4) NOT NULL default '2',
  Modified int(11) NOT NULL default '0',
  dob INT(11) NULL DEFAULT NULL,
  tz int(11) default NULL,
  ip varchar(20) default NULL,
  IsBanned tinyint(1) NOT NULL default '0',
  PassResetTime INT(11) UNSIGNED NULL DEFAULT NULL,
  PwResetConfirm varchar(255) default NULL,
  PwRequestTime INT(11) UNSIGNED NULL DEFAULT NULL,
  MinPwResetDelay int(11) NOT NULL default '1800',
  PRIMARY KEY  (PortalUserId),
  UNIQUE KEY ResourceId (ResourceId),
  UNIQUE KEY Login (Login),
  KEY CreatedOn (CreatedOn),
  KEY Status (Status),
  KEY Modified (Modified),
  KEY dob (dob),
  KEY IsBanned (IsBanned)
);

CREATE TABLE PortalUserCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE SessionData (
  SessionKey varchar(50) NOT NULL default '',
  VariableName varchar(255) NOT NULL default '',
  VariableValue longtext NOT NULL,
  PRIMARY KEY  (SessionKey,VariableName),
  KEY SessionKey (SessionKey),
  KEY VariableName (VariableName)
);

CREATE TABLE Theme (
  ThemeId int(11) NOT NULL auto_increment,
  Name varchar(40) NOT NULL default '',
  Enabled int(11) NOT NULL default '1',
  Description varchar(255) default NULL,
  PrimaryTheme int(11) NOT NULL default '0',
  CacheTimeout int(11) NOT NULL default '0',
  StylesheetId int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (ThemeId),
  KEY Enabled (Enabled),
  KEY StylesheetId (StylesheetId),
  KEY PrimaryTheme (PrimaryTheme)
);

CREATE TABLE ThemeFiles (
  FileId int(11) NOT NULL auto_increment,
  ThemeId int(11) NOT NULL default '0',
  FileName varchar(255) NOT NULL default '',
  FilePath varchar(255) NOT NULL default '',
  Description varchar(255) default NULL,
  FileType int(11) NOT NULL default '0',
  FileFound tinyint(3) unsigned NOT NULL default '0',
  FileMetaInfo text,
  PRIMARY KEY  (FileId),
  KEY theme (ThemeId),
  KEY FileName (FileName),
  KEY FilePath (FilePath),
  KEY FileFound (FileFound)
);

CREATE TABLE UserGroup (
  PortalUserId int(11) NOT NULL default '0',
  GroupId int(11) NOT NULL default '0',
  MembershipExpires int(10) unsigned default NULL,
  PrimaryGroup tinyint(4) NOT NULL default '1',
  ExpirationReminderSent tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (PortalUserId,GroupId),
  KEY GroupId (GroupId),
  KEY PrimaryGroup (PrimaryGroup),
  KEY MembershipExpires (MembershipExpires),
  KEY ExpirationReminderSent (ExpirationReminderSent)
);

CREATE TABLE UserSession (
  SessionKey int(10) unsigned NOT NULL DEFAULT '0',
  LastAccessed int(10) unsigned NOT NULL DEFAULT '0',
  PortalUserId int(11) NOT NULL DEFAULT '-2',
  `Language` int(11) NOT NULL DEFAULT '1',
  Theme int(11) NOT NULL DEFAULT '1',
  GroupId int(11) NOT NULL DEFAULT '0',
  IpAddress varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `Status` int(11) NOT NULL DEFAULT '1',
  GroupList varchar(255) DEFAULT NULL,
  tz int(11) DEFAULT NULL,
  BrowserSignature varchar(32) NOT NULL,
  PRIMARY KEY (SessionKey),
  KEY UserId (PortalUserId),
  KEY LastAccessed (LastAccessed),
  KEY BrowserSignature (BrowserSignature)
);

CREATE TABLE EmailLog (
  EmailLogId int(11) NOT NULL auto_increment,
  fromuser varchar(200) default NULL,
  addressto varchar(255) default NULL,
  `subject` varchar(255) default NULL,
  `timestamp` bigint(20) default '0',
  event varchar(100) default NULL,
  EventParams text NOT NULL,
  PRIMARY KEY  (EmailLogId),
  KEY `timestamp` (`timestamp`)
);

CREATE TABLE Cache (
  VarName varchar(255) NOT NULL default '',
  Data longtext,
  Cached int(11) default NULL,
  LifeTime int(11) NOT NULL default '-1',
  PRIMARY KEY  (VarName),
  KEY Cached (Cached)
);

CREATE TABLE StdDestinations (
  DestId int(11) NOT NULL auto_increment,
  DestType int(11) NOT NULL default '0',
  DestParentId int(11) default NULL,
  DestName varchar(255) NOT NULL default '',
  DestAbbr char(3) NOT NULL default '',
  DestAbbr2 char(2) default NULL,
  PRIMARY KEY  (DestId),
  KEY DestType (DestType),
  KEY DestParentId (DestParentId)
);

CREATE TABLE Category (
  CategoryId int(11) NOT NULL auto_increment,
  `Type` int(11) NOT NULL default '0',
  SymLinkCategoryId int(10) unsigned default NULL,
  ParentId int(11) NOT NULL default '0',
  `Name` varchar(255) NOT NULL default '',
  l1_Name varchar(255) NOT NULL default '',
  l2_Name varchar(255) NOT NULL default '',
  l3_Name varchar(255) NOT NULL default '',
  l4_Name varchar(255) NOT NULL default '',
  l5_Name varchar(255) NOT NULL default '',
  Filename varchar(255) NOT NULL default '',
  AutomaticFilename tinyint(3) unsigned NOT NULL default '1',
  Description text,
  l1_Description text,
  l2_Description text,
  l3_Description text,
  l4_Description text,
  l5_Description text,
  CreatedOn int(11) NOT NULL default '0',
  EditorsPick tinyint(4) NOT NULL default '0',
  `Status` tinyint(4) NOT NULL default '2',
  Priority int(11) NOT NULL default '0',
  MetaKeywords text,
  CachedDescendantCatsQty int(11) default NULL,
  CachedNavbar text,
  l1_CachedNavbar text,
  l2_CachedNavbar text,
  l3_CachedNavbar text,
  l4_CachedNavbar text,
  l5_CachedNavbar text,
  CreatedById int(11) NOT NULL default '0',
  ResourceId int(11) default NULL,
  ParentPath text,
  TreeLeft bigint(20) NOT NULL default '0',
  TreeRight bigint(20) NOT NULL default '0',
  NamedParentPath text,
  MetaDescription text,
  HotItem int(11) NOT NULL default '2',
  NewItem int(11) NOT NULL default '2',
  PopItem int(11) NOT NULL default '2',
  Modified int(11) NOT NULL default '0',
  ModifiedById int(11) NOT NULL default '0',
  CachedTemplate varchar(255) NOT NULL,
  Template varchar(255) NOT NULL default '#inherit#',
  UseExternalUrl tinyint(3) unsigned NOT NULL default '0',
  ExternalUrl varchar(255) NOT NULL default '',
  UseMenuIconUrl tinyint(3) unsigned NOT NULL default '0',
  MenuIconUrl varchar(255) NOT NULL default '',
  l1_Title varchar(255) default '',
  l2_Title varchar(255) default '',
  l3_Title varchar(255) default '',
  l4_Title varchar(255) default '',
  l5_Title varchar(255) default '',
  l1_MenuTitle varchar(255) NOT NULL default '',
  l2_MenuTitle varchar(255) NOT NULL default '',
  l3_MenuTitle varchar(255) NOT NULL default '',
  l4_MenuTitle varchar(255) NOT NULL default '',
  l5_MenuTitle varchar(255) NOT NULL default '',
  MetaTitle text,
  IndexTools text,
  IsIndex tinyint(1) NOT NULL default '0',
  IsMenu tinyint(4) NOT NULL default '1',
  IsSystem tinyint(4) NOT NULL default '0',
  FormId int(11) default NULL,
  FormSubmittedTemplate varchar(255) default NULL,
  l1_Translated tinyint(4) NOT NULL default '0',
  l2_Translated tinyint(4) NOT NULL default '0',
  l3_Translated tinyint(4) NOT NULL default '0',
  l4_Translated tinyint(4) NOT NULL default '0',
  l5_Translated tinyint(4) NOT NULL default '0',
  FriendlyURL varchar(255) NOT NULL default '',
  ThemeId int(10) unsigned NOT NULL,
  PRIMARY KEY  (CategoryId),
  UNIQUE KEY ResourceId (ResourceId),
  KEY ParentId (ParentId),
  KEY Modified (Modified),
  KEY Priority (Priority),
  KEY sorting (`Name`,Priority),
  KEY Filename (Filename(5)),
  KEY l1_Name (l1_Name(5)),
  KEY l2_Name (l2_Name(5)),
  KEY l3_Name (l3_Name(5)),
  KEY l4_Name (l4_Name(5)),
  KEY l5_Name (l5_Name(5)),
  KEY l1_Description (l1_Description(5)),
  KEY l2_Description (l2_Description(5)),
  KEY l3_Description (l3_Description(5)),
  KEY l4_Description (l4_Description(5)),
  KEY l5_Description (l5_Description(5)),
  KEY TreeLeft (TreeLeft),
  KEY TreeRight (TreeRight),
  KEY SymLinkCategoryId (SymLinkCategoryId),
  KEY `Status` (`Status`),
  KEY CreatedOn (CreatedOn),
  KEY EditorsPick (EditorsPick),
  KEY IsIndex (IsIndex),
  KEY l1_Translated (l1_Translated),
  KEY l2_Translated (l2_Translated),
  KEY l3_Translated (l3_Translated),
  KEY l4_Translated (l4_Translated),
  KEY l5_Translated (l5_Translated),
  KEY ThemeId (ThemeId)
);

CREATE TABLE CategoryCustomData (
  CustomDataId int(11) NOT NULL auto_increment,
  ResourceId int(10) unsigned NOT NULL default '0',
  KEY ResourceId (ResourceId),
  PRIMARY KEY  (CustomDataId)
);

CREATE TABLE CategoryItems (
  CategoryId int(11) NOT NULL default '0',
  ItemResourceId int(11) NOT NULL default '0',
  PrimaryCat tinyint(4) NOT NULL default '0',
  ItemPrefix varchar(50) NOT NULL default '',
  Filename varchar(255) NOT NULL default '',
  UNIQUE KEY CategoryId (CategoryId,ItemResourceId),
  KEY PrimaryCat (PrimaryCat),
  KEY ItemPrefix (ItemPrefix),
  KEY ItemResourceId (ItemResourceId),
  KEY Filename (Filename)
);

CREATE TABLE PermCache (
  PermCacheId int(11) NOT NULL auto_increment,
  CategoryId int(11) NOT NULL default '0',
  PermId int(11) NOT NULL default '0',
  ACL varchar(255) NOT NULL default '',
  PRIMARY KEY  (PermCacheId),
  KEY CategoryId (CategoryId),
  KEY PermId (PermId)
);

CREATE TABLE Stylesheets (
  StylesheetId int(11) NOT NULL auto_increment,
  Name varchar(255) NOT NULL default '',
  Description varchar(255) NOT NULL default '',
  AdvancedCSS text NOT NULL,
  LastCompiled int(10) unsigned NOT NULL default '0',
  Enabled int(11) NOT NULL default '0',
  PRIMARY KEY  (StylesheetId),
  KEY Enabled (Enabled),
  KEY LastCompiled (LastCompiled)
);

CREATE TABLE PopupSizes (
  PopupId int(10) unsigned NOT NULL auto_increment,
  TemplateName varchar(255) NOT NULL default '',
  PopupWidth int(11) NOT NULL default '0',
  PopupHeight int(11) NOT NULL default '0',
  PRIMARY KEY  (PopupId),
  KEY TemplateName (TemplateName)
);

CREATE TABLE Counters (
  CounterId int(10) unsigned NOT NULL auto_increment,
  Name varchar(100) NOT NULL default '',
  CountQuery text,
  CountValue text,
  LastCounted int(10) unsigned default NULL,
  LifeTime int(10) unsigned NOT NULL default '3600',
  IsClone tinyint(3) unsigned NOT NULL default '0',
  TablesAffected text,
  PRIMARY KEY  (CounterId),
  UNIQUE KEY Name (Name),
  KEY IsClone (IsClone),
  KEY LifeTime (LifeTime),
  KEY LastCounted (LastCounted)
);

CREATE TABLE Skins (
  SkinId int(11) NOT NULL auto_increment,
  `Name` varchar(255) default NULL,
  CSS text,
  Logo varchar(255) default NULL,
  LogoBottom varchar(255) NOT NULL,
  LogoLogin varchar(255) NOT NULL,
  Options text,
  LastCompiled int(11) NOT NULL default '0',
  IsPrimary int(1) NOT NULL default '0',
  PRIMARY KEY  (SkinId),
  KEY IsPrimary (IsPrimary),
  KEY LastCompiled (LastCompiled)
);

CREATE TABLE ChangeLogs (
  ChangeLogId bigint(20) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  SessionLogId int(11) NOT NULL default '0',
  `Action` tinyint(4) NOT NULL default '0',
  OccuredOn int(11) NOT NULL default '0',
  Prefix varchar(255) NOT NULL default '',
  ItemId bigint(20) NOT NULL default '0',
  Changes text NOT NULL,
  MasterPrefix varchar(255) NOT NULL default '',
  MasterId bigint(20) NOT NULL default '0',
  PRIMARY KEY  (ChangeLogId),
  KEY PortalUserId (PortalUserId),
  KEY SessionLogId (SessionLogId),
  KEY `Action` (`Action`),
  KEY OccuredOn (OccuredOn),
  KEY Prefix (Prefix),
  KEY MasterPrefix (MasterPrefix)
);

CREATE TABLE SessionLogs (
  SessionLogId bigint(20) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  SessionId int(10) NOT NULL default '0',
  `Status` tinyint(4) NOT NULL default '1',
  SessionStart int(11) NOT NULL default '0',
  SessionEnd int(11) default NULL,
  IP varchar(15) NOT NULL default '',
  AffectedItems int(11) NOT NULL default '0',
  PRIMARY KEY  (SessionLogId),
  KEY SessionId (SessionId),
  KEY `Status` (`Status`),
  KEY PortalUserId (PortalUserId)
);

CREATE TABLE StatisticsCapture (
  StatisticsId int(10) unsigned NOT NULL auto_increment,
  TemplateName varchar(255) NOT NULL default '',
  Hits int(10) unsigned NOT NULL default '0',
  LastHit int(11) NOT NULL default '0',
  ScriptTimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  ScriptTimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  ScriptTimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlTimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  SqlCountMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  PRIMARY KEY  (StatisticsId),
  KEY TemplateName (TemplateName),
  KEY Hits (Hits),
  KEY LastHit (LastHit),
  KEY ScriptTimeMin (ScriptTimeMin),
  KEY ScriptTimeAvg (ScriptTimeAvg),
  KEY ScriptTimeMax (ScriptTimeMax),
  KEY SqlTimeMin (SqlTimeMin),
  KEY SqlTimeAvg (SqlTimeAvg),
  KEY SqlTimeMax (SqlTimeMax),
  KEY SqlCountMin (SqlCountMin),
  KEY SqlCountAvg (SqlCountAvg),
  KEY SqlCountMax (SqlCountMax)
);

CREATE TABLE SlowSqlCapture (
  CaptureId int(10) unsigned NOT NULL auto_increment,
  TemplateNames text,
  Hits int(10) unsigned NOT NULL default '0',
  LastHit int(11) NOT NULL default '0',
  SqlQuery text,
  TimeMin decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  TimeAvg decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  TimeMax decimal(40,20) unsigned NOT NULL default '0.00000000000000000000',
  QueryCrc int(11) NOT NULL default '0',
  PRIMARY KEY  (CaptureId),
  KEY Hits (Hits),
  KEY LastHit (LastHit),
  KEY TimeMin (TimeMin),
  KEY TimeAvg (TimeAvg),
  KEY TimeMax (TimeMax),
  KEY QueryCrc (QueryCrc)
);

CREATE TABLE Agents (
  AgentId int(11) NOT NULL auto_increment,
  AgentName varchar(255) NOT NULL default '',
  AgentType tinyint(3) unsigned NOT NULL default '1',
  Status tinyint(3) unsigned NOT NULL default '1',
  Event varchar(255) NOT NULL default '',
  RunInterval int(10) unsigned NOT NULL default '0',
  RunMode tinyint(3) unsigned NOT NULL default '2',
  LastRunOn int(10) unsigned default NULL,
  LastRunStatus tinyint(3) unsigned NOT NULL default '1',
  NextRunOn int(11) default NULL,
  RunTime int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (AgentId),
  KEY Status (Status),
  KEY RunInterval (RunInterval),
  KEY RunMode (RunMode),
  KEY AgentType (AgentType),
  KEY LastRunOn (LastRunOn),
  KEY LastRunStatus (LastRunStatus),
  KEY RunTime (RunTime),
  KEY NextRunOn (NextRunOn)
);

CREATE TABLE SpellingDictionary (
  SpellingDictionaryId int(11) NOT NULL auto_increment,
  MisspelledWord varchar(255) NOT NULL default '',
  SuggestedCorrection varchar(255) NOT NULL default '',
  PRIMARY KEY  (SpellingDictionaryId),
  KEY MisspelledWord (MisspelledWord),
  KEY SuggestedCorrection (SuggestedCorrection)
);

CREATE TABLE Thesaurus (
  ThesaurusId int(11) NOT NULL auto_increment,
  SearchTerm varchar(255) NOT NULL default '',
  ThesaurusTerm varchar(255) NOT NULL default '',
  ThesaurusType tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (ThesaurusId),
  KEY ThesaurusType (ThesaurusType),
  KEY SearchTerm (SearchTerm)
);

CREATE TABLE LocalesList (
  LocaleId int(11) NOT NULL auto_increment,
  LocaleIdentifier varchar(6) NOT NULL default '',
  LocaleName varchar(255) NOT NULL default '',
  Locale varchar(20) NOT NULL default '',
  ScriptTag varchar(255) NOT NULL default '',
  ANSICodePage varchar(10) NOT NULL default '',
  PRIMARY KEY (LocaleId)
);

CREATE TABLE BanRules (
  RuleId int(11) NOT NULL auto_increment,
  RuleType tinyint(4) NOT NULL default '0',
  ItemField varchar(255) default NULL,
  ItemVerb tinyint(4) NOT NULL default '0',
  ItemValue varchar(255) NOT NULL default '',
  ItemType int(11) NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '1',
  ErrorTag varchar(255) default NULL,
  PRIMARY KEY  (RuleId),
  KEY Status (Status),
  KEY Priority (Priority),
  KEY ItemType (ItemType)
);

CREATE TABLE CountCache (
  ListType int(11) NOT NULL default '0',
  ItemType int(11) NOT NULL default '-1',
  Value int(11) NOT NULL default '0',
  CountCacheId int(11) NOT NULL auto_increment,
  LastUpdate int(11) NOT NULL default '0',
  ExtraId varchar(50) default NULL,
  TodayOnly tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (CountCacheId)
);

CREATE TABLE Favorites (
  FavoriteId int(11) NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '0',
  ResourceId int(11) NOT NULL default '0',
  ItemTypeId int(11) NOT NULL default '0',
  Modified int(11) NOT NULL default '0',
  PRIMARY KEY  (FavoriteId),
  UNIQUE KEY main (PortalUserId,ResourceId),
  KEY Modified (Modified),
  KEY ItemTypeId (ItemTypeId)
);

CREATE TABLE Images (
  ImageId int(11) NOT NULL auto_increment,
  ResourceId int(11) NOT NULL default '0',
  Url varchar(255) NOT NULL default '',
  Name varchar(255) NOT NULL default '',
  AltName VARCHAR(255) NOT NULL DEFAULT '',
  ImageIndex int(11) NOT NULL default '0',
  LocalImage tinyint(4) NOT NULL default '1',
  LocalPath varchar(240) NOT NULL default '',
  Enabled int(11) NOT NULL default '1',
  DefaultImg int(11) NOT NULL default '0',
  ThumbUrl varchar(255) default NULL,
  Priority int(11) NOT NULL default '0',
  ThumbPath varchar(255) default NULL,
  LocalThumb tinyint(4) NOT NULL default '1',
  SameImages tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (ImageId),
  KEY ResourceId (ResourceId),
  KEY Enabled (Enabled),
  KEY Priority (Priority)
);

CREATE TABLE ItemRating (
  RatingId int(11) NOT NULL auto_increment,
  IPAddress varchar(255) NOT NULL default '',
  CreatedOn INT UNSIGNED NULL DEFAULT NULL,
  RatingValue int(11) NOT NULL default '0',
  ItemId int(11) NOT NULL default '0',
  PRIMARY KEY  (RatingId),
  KEY CreatedOn (CreatedOn),
  KEY ItemId (ItemId),
  KEY RatingValue (RatingValue)
);

CREATE TABLE ItemReview (
  ReviewId int(11) NOT NULL auto_increment,
  CreatedOn INT UNSIGNED NULL DEFAULT NULL,
  ReviewText longtext NOT NULL,
  Rating tinyint(3) unsigned default NULL,
  IPAddress varchar(255) NOT NULL default '',
  ItemId int(11) NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-1',
  ItemType tinyint(4) NOT NULL default '0',
  Priority int(11) NOT NULL default '0',
  Status tinyint(4) NOT NULL default '2',
  TextFormat int(11) NOT NULL default '0',
  Module varchar(255) NOT NULL default '',
  PRIMARY KEY  (ReviewId),
  KEY CreatedOn (CreatedOn),
  KEY ItemId (ItemId),
  KEY ItemType (ItemType),
  KEY Priority (Priority),
  KEY Status (Status)
);

CREATE TABLE ItemTypes (
  ItemType int(11) NOT NULL default '0',
  Module varchar(50) NOT NULL default '',
  Prefix varchar(20) NOT NULL default '',
  SourceTable varchar(100) NOT NULL default '',
  TitleField varchar(50) default NULL,
  CreatorField varchar(255) NOT NULL default '',
  PopField varchar(255) default NULL,
  RateField varchar(255) default NULL,
  LangVar varchar(255) NOT NULL default '',
  PrimaryItem int(11) NOT NULL default '0',
  EditUrl varchar(255) NOT NULL default '',
  ClassName varchar(40) NOT NULL default '',
  ItemName varchar(50) NOT NULL default '',
  PRIMARY KEY  (ItemType),
  KEY Module (Module)
);

CREATE TABLE ItemFiles (
  FileId int(11) NOT NULL auto_increment,
  ResourceId int(11) unsigned NOT NULL default '0',
  FileName varchar(255) NOT NULL default '',
  FilePath varchar(255) NOT NULL default '',
  Size int(11) NOT NULL default '0',
  `Status` tinyint(4) NOT NULL default '1',
  CreatedOn int(11) unsigned NOT NULL default '0',
  CreatedById int(11) NOT NULL default '-1',
  MimeType varchar(255) NOT NULL default '',
  PRIMARY KEY  (FileId),
  KEY ResourceId (ResourceId),
  KEY CreatedOn (CreatedOn),
  KEY Status (Status)
);

CREATE TABLE Relationship (
  RelationshipId int(11) NOT NULL auto_increment,
  SourceId int(11) default NULL,
  TargetId int(11) default NULL,
  SourceType tinyint(4) NOT NULL default '0',
  TargetType tinyint(4) NOT NULL default '0',
  Type int(11) NOT NULL default '0',
  Enabled int(11) NOT NULL default '1',
  Priority int(11) NOT NULL default '0',
  PRIMARY KEY  (RelationshipId),
  KEY RelSource (SourceId),
  KEY RelTarget (TargetId),
  KEY `Type` (`Type`),
  KEY Enabled (Enabled),
  KEY Priority (Priority),
  KEY SourceType (SourceType),
  KEY TargetType (TargetType)
);

CREATE TABLE SearchConfig (
  TableName varchar(40) NOT NULL default '',
  FieldName varchar(40) NOT NULL default '',
  SimpleSearch tinyint(4) NOT NULL default '1',
  AdvancedSearch tinyint(4) NOT NULL default '1',
  Description varchar(255) default NULL,
  DisplayName varchar(80) default NULL,
  ModuleName VARCHAR(20) NOT NULL DEFAULT 'In-Portal',
  ConfigHeader varchar(255) default NULL,
  DisplayOrder int(11) NOT NULL default '0',
  SearchConfigId int(11) NOT NULL auto_increment,
  Priority int(11) NOT NULL default '0',
  FieldType varchar(20) NOT NULL default 'text',
  ForeignField TEXT,
  JoinClause TEXT,
  IsWhere text,
  IsNotWhere text,
  ContainsWhere text,
  NotContainsWhere text,
  CustomFieldId int(11) default NULL,
  PRIMARY KEY  (SearchConfigId),
  KEY SimpleSearch (SimpleSearch),
  KEY AdvancedSearch (AdvancedSearch),
  KEY DisplayOrder (DisplayOrder),
  KEY Priority (Priority),
  KEY CustomFieldId (CustomFieldId)
);

CREATE TABLE SearchLog (
  SearchLogId int(11) NOT NULL auto_increment,
  Keyword varchar(255) NOT NULL default '',
  Indices bigint(20) NOT NULL default '0',
  SearchType int(11) NOT NULL default '0',
  PRIMARY KEY  (SearchLogId),
  KEY Keyword (Keyword),
  KEY SearchType (SearchType)
);

CREATE TABLE IgnoreKeywords (
  keyword varchar(20) NOT NULL default '',
  PRIMARY KEY  (keyword)
);

CREATE TABLE SpamControl (
  ItemResourceId int(11) NOT NULL default '0',
  IPaddress varchar(20) NOT NULL default '',
  Expire INT UNSIGNED NULL DEFAULT NULL,
  PortalUserId int(11) NOT NULL default '0',
  DataType varchar(20) default NULL,
  KEY PortalUserId (PortalUserId),
  KEY Expire (Expire),
  KEY DataType (DataType),
  KEY ItemResourceId (ItemResourceId)
);

CREATE TABLE StatItem (
  StatItemId int(11) NOT NULL auto_increment,
  Module varchar(20) NOT NULL default '',
  ValueSQL varchar(255) default NULL,
  ResetSQL varchar(255) default NULL,
  ListLabel varchar(255) NOT NULL default '',
  Priority int(11) NOT NULL default '0',
  AdminSummary int(11) NOT NULL default '0',
  PRIMARY KEY  (StatItemId),
  KEY AdminSummary (AdminSummary),
  KEY Priority (Priority)
);

CREATE TABLE SysCache (
  SysCacheId int(11) NOT NULL auto_increment,
  Name varchar(255) NOT NULL default '',
  Value mediumtext,
  Expire INT UNSIGNED NULL DEFAULT NULL,
  Module varchar(20) default NULL,
  Context varchar(255) default NULL,
  GroupList varchar(255) NOT NULL default '',
  PRIMARY KEY  (SysCacheId),
  KEY Name (Name)
);

CREATE TABLE TagLibrary (
  TagId int(11) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  description text,
  example text,
  scope varchar(20) NOT NULL default 'global',
  PRIMARY KEY  (TagId)
);

CREATE TABLE TagAttributes (
  AttrId int(11) NOT NULL auto_increment,
  TagId int(11) NOT NULL default '0',
  Name varchar(255) NOT NULL default '',
  AttrType varchar(20) default NULL,
  DefValue varchar(255) default NULL,
  Description TEXT,
  Required int(11) NOT NULL default '0',
  PRIMARY KEY  (AttrId),
  KEY TagId (TagId)
);

CREATE TABLE ImportScripts (
  ImportId INT(11) NOT NULL auto_increment,
  Name VARCHAR(255) NOT NULL DEFAULT '',
  Description TEXT NOT NULL,
  Prefix VARCHAR(10) NOT NULL DEFAULT '',
  Module VARCHAR(50) NOT NULL DEFAULT '',
  ExtraFields VARCHAR(255) NOT NULL DEFAULT '',
  Type VARCHAR(10) NOT NULL DEFAULT '',
  Status TINYINT NOT NULL,
  PRIMARY KEY (ImportId),
  KEY Module (Module),
  KEY Status (Status)
);

CREATE TABLE StylesheetSelectors (
  SelectorId int(11) NOT NULL auto_increment,
  StylesheetId int(11) NOT NULL default '0',
  Name varchar(255) NOT NULL default '',
  SelectorName varchar(255) NOT NULL default '',
  SelectorData text NOT NULL,
  Description text NOT NULL,
  Type tinyint(4) NOT NULL default '0',
  AdvancedCSS text NOT NULL,
  ParentId int(11) NOT NULL default '0',
  PRIMARY KEY  (SelectorId),
  KEY StylesheetId (StylesheetId),
  KEY ParentId (ParentId),
  KEY `Type` (`Type`)
);

CREATE TABLE Visits (
  VisitId int(11) NOT NULL auto_increment,
  VisitDate int(10) unsigned NOT NULL default '0',
  Referer varchar(255) NOT NULL default '',
  IPAddress varchar(15) NOT NULL default '',
  AffiliateId int(10) unsigned NOT NULL default '0',
  PortalUserId int(11) NOT NULL default '-2',
  PRIMARY KEY  (VisitId),
  KEY PortalUserId (PortalUserId),
  KEY AffiliateId (AffiliateId),
  KEY VisitDate (VisitDate)
);

CREATE TABLE ImportCache (
  CacheId int(11) NOT NULL auto_increment,
  CacheName varchar(255) NOT NULL default '',
  VarName int(11) NOT NULL default '0',
  VarValue text NOT NULL,
  PRIMARY KEY  (CacheId),
  KEY CacheName (CacheName),
  KEY VarName (VarName)
);

CREATE TABLE RelatedSearches (
  RelatedSearchId int(11) NOT NULL auto_increment,
  ResourceId int(11) NOT NULL default '0',
  Keyword varchar(255) NOT NULL default '',
  ItemType tinyint(4) NOT NULL default '0',
  Enabled tinyint(4) NOT NULL default '1',
  Priority int(11) NOT NULL default '0',
  PRIMARY KEY  (RelatedSearchId),
  KEY Enabled (Enabled),
  KEY ItemType (ItemType),
  KEY ResourceId (ResourceId)
);

CREATE TABLE StopWords (
  StopWordId int(11) NOT NULL auto_increment,
  StopWord varchar(255) NOT NULL default '',
  PRIMARY KEY  (StopWordId),
  KEY StopWord (StopWord)
);

CREATE TABLE MailingLists (
  MailingId int(10) unsigned NOT NULL auto_increment,
  PortalUserId int(11) NOT NULL default '-1',
  `To` longtext,
  ToParsed longtext,
  Attachments text,
  `Subject` varchar(255) NOT NULL,
  MessageText longtext,
  MessageHtml longtext,
  `Status` tinyint(3) unsigned NOT NULL default '1',
  EmailsQueued int(10) unsigned NOT NULL,
  EmailsSent int(10) unsigned NOT NULL,
  EmailsTotal int(10) unsigned NOT NULL,
  PRIMARY KEY  (MailingId),
  KEY EmailsTotal (EmailsTotal),
  KEY EmailsSent (EmailsSent),
  KEY EmailsQueued (EmailsQueued),
  KEY `Status` (`Status`),
  KEY PortalUserId (PortalUserId)
);

CREATE TABLE PageContent (
  PageContentId int(11) NOT NULL auto_increment,
  ContentNum int(11) NOT NULL default '0',
  PageId int(11) NOT NULL default '0',
  l1_Content text,
  l2_Content text,
  l3_Content text,
  l4_Content text,
  l5_Content text,
  l1_Translated tinyint(4) NOT NULL default '0',
  l2_Translated tinyint(4) NOT NULL default '0',
  l3_Translated tinyint(4) NOT NULL default '0',
  l4_Translated tinyint(4) NOT NULL default '0',
  l5_Translated tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (PageContentId),
  KEY ContentNum (ContentNum,PageId)
);

CREATE TABLE FormFields (
  FormFieldId int(11) NOT NULL auto_increment,
  FormId int(11) NOT NULL default '0',
  Type int(11) NOT NULL default '0',
  FieldName varchar(255) NOT NULL default '',
  FieldLabel varchar(255) default NULL,
  Heading varchar(255) default NULL,
  Prompt varchar(255) default NULL,
  ElementType varchar(50) NOT NULL default '',
  ValueList varchar(255) default NULL,
  Priority int(11) NOT NULL default '0',
  IsSystem tinyint(3) unsigned NOT NULL default '0',
  Required tinyint(1) NOT NULL default '0',
  DisplayInGrid tinyint(1) NOT NULL default '1',
  DefaultValue text NOT NULL,
  Validation TINYINT NOT NULL DEFAULT '0',
  PRIMARY KEY  (FormFieldId),
  KEY `Type` (`Type`),
  KEY FormId (FormId),
  KEY Priority (Priority),
  KEY IsSystem (IsSystem),
  KEY DisplayInGrid (DisplayInGrid)
);

CREATE TABLE FormSubmissions (
  FormSubmissionId int(11) NOT NULL auto_increment,
  FormId int(11) NOT NULL default '0',
  SubmissionTime int(11) NOT NULL default '0',
  PRIMARY KEY  (FormSubmissionId),
  KEY FormId (FormId),
  KEY SubmissionTime (SubmissionTime)
);

CREATE TABLE Forms (
  FormId int(11) NOT NULL auto_increment,
  Title VARCHAR(255) NOT NULL DEFAULT '',
  Description text,
  PRIMARY KEY  (FormId)
);

CREATE TABLE Semaphores (
  SemaphoreId int(11) NOT NULL auto_increment,
  SessionKey int(10) unsigned NOT NULL,
  Timestamp int(10) unsigned NOT NULL,
  MainPrefix varchar(255) NOT NULL,
  PRIMARY KEY  (SemaphoreId),
  KEY SessionKey (SessionKey),
  KEY Timestamp (Timestamp),
  KEY MainPrefix (MainPrefix)
);