<?php
/**
* @version	$Id: themes_tag_processor.php 12299 2009-08-17 01:51:27Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ThemesTagProcessor extends kDBTagProcessor
	{
		function StylesheetFile($params)
		{
			$object =& $this->getObject($params);
			if (!$object->GetDBField('StyleName')) {
				// no stylesheet is associated with current theme
				return '';
			}

			$css_url = $this->Application->BaseURL(WRITEBALE_BASE . '/stylesheets');
			$css_path = rtrim( str_replace( $this->Application->BaseURL(), FULL_PATH . '/', $css_url), '/' );

			$last_compiled = $object->GetDBField('LastCompiled');

			$style_name = mb_strtolower( $object->GetDBField('StyleName') );

			if( file_exists($css_path.'/'.$style_name.'-'.$last_compiled.'.css') )
			{
				$ret = rtrim($css_url, '/').'/'.$style_name.'-'.$last_compiled.'.css';

			}
			else
			{
				// search for previously compiled stylesheet
				$last_compiled = 0;
				if( $dh = opendir($css_path) )
				{
					while( ($file = readdir($dh)) !== false )
					{
						if( preg_match('/(.*)-([\d]+).css/', $file, $rets) )
						{
							if( $rets[1] == $style_name && $rets[2] > $last_compiled ) $last_compiled = $rets[2];
						}
					}
					closedir($dh);
				}
				if ($last_compiled) {
					// found
					$ret = $css_url.'/'.$style_name.'-'.$last_compiled.'.css';
				}
				else {
					// not found
					return '';
				}
			}

			if (isset($params['file_only'])) return $ret;

			return '<link rel="stylesheet" rev="stylesheet" href="'.$ret.'" type="text/css" media="screen" />';
		}

		function SelectedTheme($params)
		{
			$object =& $this->getObject($params);

			$themes_helper =& $this->Application->recallObject('ThemesHelper');
			/* @var $themes_helper kThemesHelper */

			return $object->GetDBField('ThemeId') == $themes_helper->getCurrentThemeId();
		}
	}
