<?php
/**
* @version	$Id: modules_event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class ModulesEventHandler extends kDBEventHandler {

		/**
		 * Builds item
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		function OnItemBuild(&$event)
		{
			$this->Application->SetVar($event->getPrefixSpecial(true).'_id', $event->Special);
			parent::OnItemBuild($event);
		}

		/**
		 * List with one record if special passed
		 *
		 * @param kEvent $event
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();
			if ($event->Special) {
				$object->addFilter('current_module', 'Name = '.$event->Special);
			}

			$object->addFilter('not_core', '%1$s.Name <> "Core"');
		}

		function mapEvents()
		{
			parent::mapEvents();
			$this->eventMethods['OnMassApprove'] = 'moduleAction';
			$this->eventMethods['OnMassDecline'] = 'moduleAction';
		}

		/**
		 * Disabled modules, but not In-Portal
		 *
		 * @param kEvent $event
		 */
		function moduleAction(&$event)
		{
			if ($this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				return ;
			}

			$object =& $event->getObject( Array('skip_autoload' => true) );
			$ids = $this->StoreSelectedIDs($event);


			if (!$ids) {
				return true;
			}

			$status_field = array_shift( $this->Application->getUnitOption($event->Prefix, 'StatusField') );

			foreach ($ids as $id) {
				if (($event->Name == 'OnMassDecline') && ($id == 'In-Portal')) {
					// don't allow to disable in-portal
					continue;
				}

				if ($id == 'Core') {
					// don't allow any kind of manupulations with kernel
					continue;
				}

				$object->Load($id);

				$object->SetDBField($status_field, $event->Name == 'OnMassApprove' ? 1 : 0);

				if ($object->Update()) {
					$event->status = erSUCCESS;
					$event->redirect_params = Array('opener' => 's'); //stay!
				}
				else {
					$event->status = erFAIL;
					$event->redirect = false;
					break;
				}
			}

			$this->Application->UnitConfigReader->ResetParsedData(true); //true to reset sections cache also
			$event->SetRedirectParam('RefreshTree', 1);
		}

		/**
		 * Occures after list is queried
		 *
		 * @param kEvent $event
		 */
		function OnAfterListQuery(&$event)
		{
			parent::OnAfterListQuery($event);

			$new_modules = $this->_getNewModules();
			if (!$new_modules) {
				return ;
			}

			require_once FULL_PATH . '/core/install/install_toolkit.php';

			$toolkit = new kInstallToolkit();

			$object =& $event->getObject();
			/* @var $object kDBList */

			foreach ($new_modules as $module) {
				$module_record = Array (
					'Name' => $toolkit->getModuleName($module),
					'Loaded' => 0,
					'Version' => $toolkit->GetMaxModuleVersion($module),
				);

				$object->addRecord($module_record);
			}
		}

		/**
		 * Returns list of modules, that are not installed, but available in file system
		 *
		 * @return Array
		 */
		function _getNewModules()
		{
			$modules_helper =& $this->Application->recallObject('ModulesHelper');
			/* @var $modules_helper kModulesHelper */

			$modules = Array ();
			if ($dir = @opendir(MODULES_PATH)) {
				while (($file = readdir($dir)) !== false) {
					if ($file != '.' && $file != '..') {
						$module_folder = MODULES_PATH . '/' . $file;
						if (is_dir($module_folder) && $this->_isModule($module_folder)) {
							// this is module -> check if it's installed already
							if (!$modules_helper->moduleInstalled($file)) {
								$install_order = trim( file_get_contents($module_folder . '/install/install_order.txt') );
								$modules[$install_order] = $file;
							}
						}
					}
				}

				closedir($dir);
			}

			// allows to control module install order
			ksort($modules, SORT_NUMERIC);
			return $modules;
		}

		/**
		 * Checks, that given folder is module root folder
		 *
		 * @param string $folder
		 * @return bool
		 */
		function _isModule($folder)
		{
			return file_exists($folder . '/install.php') && file_exists($folder . '/install/install_schema.sql');
		}
	}

?>