<?php
/**
* @version	$Id: config_search_tag_processor.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class ConfigSearchTagProcessor extends kDBTagProcessor {

	/**
	 * Prints list content using block specified
	 *
	 * @param Array $params
	 * @return string
	 * @access public
	 */
	function PrintList($params)
	{
		$list =& $this->GetList($params);
		$id_field = $this->Application->getUnitOption($this->Prefix,'IDField');

		$list->Query();
		$o = '';
		$list->GoFirst();

		$block_params = $this->prepareTagParams($params);
		$block_params['name'] = $this->SelectParam($params, 'render_as,block');
		$block_params['pass_params'] = 'true';
		
		$this->groupRecords($list->Records, 'ConfigHeader');
		$prev_heading = '';
		
		while (!$list->EOL())
		{
			$this->Application->SetVar( $this->getPrefixSpecial().'_id', $list->GetDBField($id_field) ); // for edit/delete links using GET
			$block_params['show_heading'] = ($prev_heading != $list->GetDBField('ConfigHeader') ) ? 1 : 0;
			
			$o.= $this->Application->ParseBlock($block_params, 1);
			$prev_heading = $list->GetDBField('ConfigHeader');
			$list->GoNext();
		}

		$this->Application->SetVar( $this->getPrefixSpecial().'_id', '');
		return $o;
	}
}

?>