<?php
/**
* @version	$Id: captcha_eh.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class CaptchaEventHandler extends kEventHandler {

		/**
		 * [HOOK] Validates captcha code in item
		 *
		 * @param kEvent $event
		 */
		function OnValidateCode(&$event)
		{
			$captcha_helper =& $this->Application->recallObject('CaptchaHelper');
			/* @var $captcha_helper kCaptchaHelper */

			$captcha_helper->validateCode($event->MasterEvent);
		}

		/**
		 * [HOOK] Initializes captcha code processing routine
		 *
		 * @param kEvent $event
		 */
		function OnPrepareCaptcha(&$event)
		{
			$captcha_helper =& $this->Application->recallObject('CaptchaHelper');
			/* @var $captcha_helper kCaptchaHelper */

			// generate captcha code
			$captcha_helper->prepareCode($event->MasterEvent);

			// create field for captcha code storage
			$virtual_fields = $this->Application->getUnitOption($event->MasterEvent->Prefix, 'VirtualFields');
			$virtual_fields['Captcha'] = Array ('type' => 'string', 'default' => '');
			$this->Application->setUnitOption($event->MasterEvent->Prefix, 'VirtualFields', $virtual_fields);
		}
	}
