<?php
/**
* @version	$Id: tag_processor.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class TagProcessor extends kBase {

		/**
		 * Processes tag
		 *
		 * @param Tag $tag
		 * @return string
		 * @access public
		 */
		function ProcessTag(&$tag)
		{
			return $this->ProcessParsedTag($tag->Tag, $tag->NP, $tag->getPrefixSpecial());

			/*$Method=$tag->Tag;
			if(method_exists($this, $Method))
			{
				//echo htmlspecialchars($tag->GetFullTag()).'<br>';
				return $this->$Method($tag->NP);
			}
			else
			{
				if ($this->Application->hasObject('TagsAggregator')) {
					$aggregator =& $this->Application->recallObject('TagsAggregator');
					$tag_mapping = $aggregator->GetArrayValue($tag->Prefix, $Method);
					if ($tag_mapping) {

						$mapped_tag = new Tag('', $this->Application->Parser);
						$mapped_tag->CopyFrom($tag);
						$mapped_tag->Processor = $tag_mapping[0];
						$mapped_tag->Tag = $tag_mapping[1];
						$mapped_tag->NP['PrefixSpecial'] = $tag->getPrefixSpecial();
						$mapped_tag->RebuildTagData();
						return $mapped_tag->DoProcessTag();
					}
				}
				trigger_error('Tag '.$Method.' Undefined in '.get_class($this).'[Agregated Tag]:<br><b>'.$tag->RebuildTagData().'</b>',E_USER_WARNING);
				return false;
			}*/
		}

		function CheckTag($tag, $prefix)
		{
			$Method = $tag;
			if(method_exists($this, $Method))
			{
				return true;
			}
			else {
				if ($this->Application->hasObject('TagsAggregator')) {
					$aggregator =& $this->Application->recallObject('TagsAggregator');
					$tmp = $this->Application->processPrefix($prefix);
					$tag_mapping = $aggregator->GetArrayValue($tmp['prefix'], $Method);
					if ($tag_mapping) {
						return true;
					}
				}
			}
		}

		function FormCacheKey($tag, $params, $prefix)
		{
			$k = $this->Application->Parser->TemplateName;
			$k .= $prefix.'_'.$tag;
			foreach (array('m_cat_id','m_cat_page','m_lang','m_theme') as $m_var) {
				$params[$m_var] = $this->Application->GetVar($m_var);
			}

			ksort($params);
			foreach ($params as $p => $v) {
				$k .= "$p=$v&";
			}

			return md5($k);
		}

		function ProcessParsedTag($tag, $params, $prefix, $file='unknown', $line=0)
		{
			$Method = $tag;
			if (method_exists($this, $Method)) {
				if ($this->Application->isDebugMode() && constOn('DBG_SHOW_TAGS')) {
					$this->Application->Debugger->appendHTML('Processing PreParsed Tag '.$Method.' in '.$this->Prefix);
				}

				$backup_prefix = $this->Prefix;
				$backup_special = $this->Special;

				if ($this->Application->ConfigValue('SystemTagCache') && isset($params['cache_timeout'])) {
					if ($res = $this->Application->CacheGet($this->FormCacheKey($tag, $params, $prefix))) {
						return $res;
					}
				}

				$original_params = $params;
				$flag_values = $this->PreparePostProcess($params);

				// pass_params for non ParseBlock tags :)
				if ($flag_values['pass_params']) {
					$params = array_merge_recursive2($this->Application->Parser->Params, $params);
				}

				$ret = $this->$Method($params);

				$this->Prefix = $backup_prefix;
				$this->Special = $backup_special;

				$ret = $this->PostProcess($ret, $flag_values);
				if ($this->Application->ConfigValue('SystemTagCache') && $flag_values['cache_timeout'] && isset($this->Application->Memcached)) {
					$this->Application->CacheSet($this->FormCacheKey($tag, $original_params, $prefix), $ret, $flag_values['cache_timeout']);
				}
				return $ret;
			}
			else {
				list ($ret, $tag_found) = $this->processAggregatedTag($tag, $params, $prefix, $file, $line);

				if ($tag_found) {
					return $ret;
				}

				$this->Application->handleError(E_USER_ERROR, 'Tag Undefined:<br><b>'.$prefix.':'.$tag.'</b>', $file, $line);
				return false;
			}
		}

		function processAggregatedTag($tag, $params, $prefix, $file = 'unknown', $line = 0)
		{
			if ($this->Application->hasObject('TagsAggregator')) {
				$Method = $tag;
				$aggregator =& $this->Application->recallObject('TagsAggregator');
				$tmp = $this->Application->processPrefix($prefix);
				$tag_mapping = $aggregator->GetArrayValue($tmp['prefix'], $Method);
				if ($tag_mapping) {
					// aggregated tag defined
					$tmp = $this->Application->processPrefix($tag_mapping[0]);
					$__tag_processor = $tmp['prefix'].'_TagProcessor';
					$processor =& $this->Application->recallObject($__tag_processor);
					$processor->Prefix = $tmp['prefix'];
					$processor->Special = getArrayValue($tag_mapping, 2) ? $tag_mapping[2] : $tmp['special'];

					$params['original_tag'] = $Method; // allows to define same method for different aggregated tags in same tag processor
					$params['PrefixSpecial'] = $this->getPrefixSpecial(); // $prefix;
					$ret = $processor->ProcessParsedTag($tag_mapping[1], $params, $prefix);
					if (isset($params['result_to_var'])) {
						$this->Application->Parser->SetParam($params['result_to_var'], $ret);
						$ret = '';
					}
					return Array ($ret, true);
				}
				else {
					// aggregated tag not defined
					if ($this->Application->isDebugMode()) {
						$this->Application->Debugger->appendTrace();
					}
					$this->Application->handleError(E_USER_ERROR, 'Tag <b>'.$Method.'</b> Undefined in '.get_class($this).'[Agregated Tag]:<br><b>'.$tag.'</b>', $file, $line);
				}
			}

			return Array ('', false);
		}

		function PreparePostProcess(&$params)
		{
			$flags = Array('js_escape', 'equals_to', 'result_to_var', 'pass_params', 'html_escape', 'strip_nl', 'trim', 'cache_timeout');
			$flag_values = Array();

			foreach ($flags as $flag_name) {
				$flag_values[$flag_name] = false;
				if (isset($params[$flag_name])) {
					$flag_values[$flag_name] = $params[$flag_name];
					unset($params[$flag_name]);
				}
			}
			return $flag_values;
		}

		function PostProcess($ret, $flag_values)
		{
			if ($flag_values['html_escape']) {
				$ret = htmlspecialchars($ret);
			}
			if ($flag_values['js_escape']) {
				$ret = addslashes($ret);
				$ret = str_replace(Array("\r", "\n"), Array('\r', '\n'), $ret);
				$ret = str_replace('</script>', "</'+'script>", $ret);
			}
			if ($flag_values['strip_nl']) {
				// 1 - strip \r,\n; 2 - strip tabs too
				$ret = preg_replace($flag_values['strip_nl'] == 2 ? "/[\r\n\t]/" : "/[\r\n]/", '', $ret);
			}
			if ($flag_values['trim']) {
				$ret = trim($ret);
			}
			// TODO: in new parser implement this parameter in compiled code (by Alex)
			if ($flag_values['equals_to'] !== false) {
				$equals_to = explode('|', $flag_values['equals_to']);
				$ret = in_array($ret, $equals_to);
			}

			if ($flag_values['result_to_var']) {
				$this->Application->Parser->SetParam($flag_values['result_to_var'], $ret);
				$ret = '';
			}
			return $ret;
		}


	 /**
	 * Not tag, method for parameter
	 * selection from list in this TagProcessor
	 *
	 * @param Array $params
	 * @param string $possible_names
	 * @return string
	 * @access public
	 */
	function SelectParam($params, $possible_names = null)
	{
		if (!isset($possible_names)) {
			// select 1st parameter non-empty parameter value
			$possible_names = explode(',', $params['possible_names']);
			foreach ($possible_names as $param_name) {
				$value = $this->Application->Parser->GetParam($param_name);
				if (((string)$value != '') && ((string)$value != '0')) {
					return $value;
				}
			}

			return '';
		}

		if (!is_array($params)) {
			// really happens?
			return;
		}

		if (!is_array($possible_names)) {
			$possible_names = explode(',', $possible_names);
		}

		foreach ($possible_names as $name) {
			if( isset($params[$name]) ) return $params[$name];
		}

		return false;
	}
}

/*class ProcessorsPool {
	var $Processors = Array();
	var $Application;
	var $Prefixes = Array();
	var $S;

	function ProcessorsPool()
	{
		$this->Application =& KernelApplication::Instance();
		$this->S =& $this->Application->Session;
	}

	function RegisterPrefix($prefix, $path, $class)
	{
		// echo " RegisterPrefix $prefix, $path, $class <br>";
		$prefix_item = Array(
			'path' => $path,
			'class' => $class
		);
		$this->Prefixes[$prefix] = $prefix_item;
	}

	function CreateProcessor($prefix, &$tag)
	{
		// echo " prefix : $prefix <br>";
		if (!isset($this->Prefixes[$prefix]))
			$this->Application->ApplicationDie ("<b>Filepath and ClassName for prefix $prefix not defined while processing ".htmlspecialchars($tag->GetFullTag())."!</b>");
		include_once($this->Prefixes[$prefix]['path']);
		$ClassName = $this->Prefixes[$prefix]['class'];
		$a_processor = new $ClassName($prefix);
		$this->SetProcessor($prefix, $a_processor);
	}

	function SetProcessor($prefix, &$a_processor)
	{
		$this->Processors[$prefix] =& $a_processor;
	}

	function &GetProcessor($prefix, &$tag)
	{
		if (!isset($this->Processors[$prefix]))
			$this->CreateProcessor($prefix, $tag);
		return $this->Processors[$prefix];
	}
}*/

?>