<?php
/**
* @version	$Id: spelling_dictionary_config.php 11902 2009-07-15 01:07:23Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	$config = Array (
		'Prefix' => 'spelling-dictionary',
		'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'SpellingDictionaryId',

		'TableName' => TABLE_PREFIX.'SpellingDictionary',

		'TitleField' => 'MisspelledWord',

		'TitlePresets' => Array (
			'default' => Array (
				'new_status_labels' => Array ('spelling-dictionary' => '!la_title_AddingSpellingDictionary!'),
				'edit_status_labels' => Array ('spelling-dictionary' => '!la_title_EditingSpellingDictionary!'),
			),

			'spelling_dictionary_list' => Array (
				'prefixes' => Array ('spelling-dictionary_List'), 'format' => "!la_title_SpellingDictionary!",
				'toolbar_buttons' => Array ('new_spelling_dictionary', 'edit', 'delete', 'export', 'view', 'dbl-click'),
			),
			'spelling_dictionary_edit' => Array (
				'prefixes'	=> Array ('spelling-dictionary'), 'format' => "#spelling-dictionary_status# '#spelling-dictionary_titlefield#'",
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
			),
		),

		'PermSection' => Array('main' => 'in-portal:spelling_dictionary'),

		'Sections' => Array (
			'in-portal:spelling_dictionary' => Array (
				'parent'		=>	'in-portal:website_setting_folder',
				'icon'			=>	'spelling_dictionary',
				'label'			=>	'la_title_SpellingDictionary',
				'url'			=>	Array('t' => 'spelling_dictionary/spelling_dictionary_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'add', 'edit', 'delete'),
				'priority'		=>	7,
				'type'			=>	stTREE,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('MisspelledWord' => 'asc'),
			)
		),

		'Fields' => Array (
			'SpellingDictionaryId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		    'MisspelledWord' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
		    'SuggestedCorrection' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_spelling_dictionary.gif'),
				'Fields' => Array (
					'SpellingDictionaryId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter',  ),
					'MisspelledWord' => Array ('title' => 'la_col_MisspelledWord', 'filter_block' => 'grid_like_filter',),
					'SuggestedCorrection' => Array ('title' => 'la_col_SuggestedCorrection', 'filter_block' => 'grid_like_filter',),
				),
			),
		),
	);