<?php
/**
* @version	$Id: modules_config.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'mod',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'ModulesEventHandler','file'=>'modules_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'ModulesTagProcessor','file'=>'modules_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
												4	=>	'mode',
											),

					'IDField'			=>	'Name',
					'TitleField'		=>	'Name',		// field, used in bluebar when editing existing item
					'StatusField'		=>	Array('Loaded'),

					'TitlePresets'		=>	Array(
						'module_list' => Array (
							'prefixes' => Array ('mod_List'), 'format' => "!la_title_Module_Status!",
							'toolbar_buttons' => Array ('approve', 'deny', 'view'),
						),
						'tree_modules'	=>	Array('format' => '!la_section_overview!'),
					),

					'PermSection'		=>	Array('main' => 'in-portal:mod_status'),

					'Sections'			=>	Array(
						'in-portal:mod_status'	=>	Array(
							'parent'		=>	'in-portal:website_setting_folder',
							'icon'			=>	'modules',
							'label'			=>	'la_title_Module_Status',
							'url'			=>	Array('t' => 'modules/modules_list', 'pass' => 'm'),
							'permissions'	=>	Array('view', 'edit', 'advanced:approve', 'advanced:decline'),
							'priority'		=>	12,
							'type'			=>	stTREE,
						),

						// "Configuration" -> "Modules and Settings"
						/*'in-portal:tag_library'	=>	Array(
							'parent'		=>	'in-portal:modules',
							'icon'			=>	'modules',
							'label'			=>	'la_tab_TagLibrary',
							'url'			=>	Array('index_file' => 'tag_listing.php', 'pass' => 'm'),
							'permissions'	=>	Array('view'),
							'priority'		=>	3,
							'type'			=>	stTREE,
						),*/
					),

					'TableName'			=>	TABLE_PREFIX.'Modules',

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array('enabled', 'disabled'), 'type' => WHERE_FILTER),
												),
												'Filters' => Array(
													'enabled'	=>	Array('label' =>'la_Enabled', 'on_sql' => '', 'off_sql' => '%1$s.Loaded != 1'),
													'disabled'	=>	Array('label' => 'la_Disabled', 'on_sql' => '', 'off_sql' => '%1$s.Loaded != 0'),
												)
											),

					'ListSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),
					'ListSortings'	=> 	Array(
												'' => Array(
													'Sorting' => Array('LoadOrder' => 'asc'),
												)
											),

					'Fields'			=>	Array(
										            'Name' => Array('type' => 'string', 'not_null' => 1, 'default' => ''),
										            'Path' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'Var' => Array('type' => 'string','not_null' => '1','default' => ''),
										            'Version' => Array('type' => 'string','not_null' => '1','default' => '0.0.0'),
										            'Loaded' => Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'la_Enabled', 0 => 'la_Disabled'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 1),
										            'LoadOrder' => Array('type' => 'int','not_null' => 1, 'default' => 0),
										            'TemplatePath' => Array('type' => 'string','not_null' => 1, 'default' => ''),
										            'RootCat' => Array('type' => 'int','not_null' => 1, 'default' => 0),
										            'BuildDate' => Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
											),

					'VirtualFields'	=> 	Array(),

					'Grids'	=> Array (
						'Default' => Array (
							'Icons' => Array ('default' => 'icon16_custom.gif'),
							'Fields' => Array (
								'Name'		=>	Array('title' => 'la_col_Name', 'data_block' => 'grid_checkbox_td_no_icon', 'header_block' => 'grid_column_title_no_sorting', 'filter_block' => 'grid_like_filter'),
								'Version' 	=>	Array('title' => 'la_col_Version', 'header_block' => 'grid_column_title_no_sorting', 'filter_block' => 'grid_like_filter'),
								'Loaded'	=>	Array('title' => 'la_col_Status', 'header_block' => 'grid_column_title_no_sorting', 'data_block' => 'grid_module_td', 'filter_block' => 'grid_options_filter'),
							),
						),
					),
	);

?>