<?php
/**
* @version	$Id: changes_formatter.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class kChangesFormatter extends kFormatter {

	function Format($value, $field_name, &$object, $format=null)
	{
		if ( is_null($value) ) {
			return '';
		}

		$changes = unserialize($value);

		$res = '';
		if (!$changes) {
			return ;
		}

		foreach ($changes as $field => $data) {
			$fld_translation = $this->Application->Phrase('la_fld_'.$field);

			// remove translation link (added in debug mode)
			$fld_translation = preg_replace('/<a href="(.*?)">(.*?)<\/a>/', '\\2', $fld_translation);

			if ($fld_translation == '!'.strtoupper('la_fld_'.$field).'!') {
				// when phrase is not translated use field name as label
				$fld_translation = $field;
			}

			if (is_array($data) && isset($data['old']) && isset($data['new'])) {
				$res .= "$fld_translation: {$data['old']} => {$data['new']}<br/>\n";
			}
			else {
				$res .= "$fld_translation: {$data['new']}<br/>\n";
			}
		}
		return $res;
	}

}