<?php
/**
* @version	$Id: email_queue_config.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	$config = Array (
		'Prefix' => 'email-queue',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array ('class' => 'kDBEventHandler', 'file' => '', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array ('class' => 'EmailQueueTagProcessor', 'file' => 'email_queue_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'Page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'EmailQueueId',

		'TableName' => TABLE_PREFIX . 'EmailQueue',

		'TitlePresets' => Array (
			'email_queue_list' => Array ('prefixes' => Array('email-queue_List'), 'format' => '!la_tab_EmailQueue!',),
		),

		'PermSection' => Array ('main' => 'in-portal:email_queue'),

		'Sections' => Array (
			'in-portal:email_queue' => Array (
				'parent'		=>	'in-portal:mailing_folder',
				'icon'			=>	'email_log',
				'label'			=>	'la_tab_EmailQueue',
				'url'			=>	Array('t' => 'logs/email_logs/email_queue_list', 'pass' => 'm'),
				'permissions'	=>	Array ('view', 'delete'),
				'priority'		=>	7.2,
				'type'			=>	stTAB,
			),
		),

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s FROM %1$s',
		),

		'ListSortings' => Array (
			'' => Array (
				'Sorting' => Array ('Queued' => 'desc'),
			)
		),

		'Fields' => Array (
			'EmailQueueId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'ToEmail' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'Subject' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
			'MessageHeaders' => Array ('type' => 'string', 'default' => NULL),
			'MessageBody' => Array ('type' => 'string', 'default' => NULL),
			'Queued' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'not_null' => 1, 'default' => 0),
			'SendRetries' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
			'LastSendRetry' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'not_null' => 1, 'default' => 0),
			'MailingId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		),

		'Grids' => Array (
			'Default' => Array (
				'Icons' => Array ('default' => 'icon16_custom.gif'),
				'Fields' => Array (
					'EmailQueueId' => Array ('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter',),
					'ToEmail' => Array ('title' => 'la_prompt_AddressTo', 'filter_block' => 'grid_like_filter', ),
					'Subject' => Array ('title' => 'la_col_Subject', 'filter_block' => 'grid_like_filter', ),
					'MessageHeaders' => Array ('title' => 'la_col_MessageHeaders', 'data_block' => 'grid_headers_td', 'filter_block' => 'grid_like_filter', ),
					'Queued' => Array ('title' => 'la_col_Queued', 'filter_block' => 'grid_date_range_filter', ),
					'SendRetries' => Array ('title' => 'la_col_SendRetries', 'filter_block' => 'grid_range_filter', ),
					'LastSendRetry' => Array ('title' => 'la_col_LastSendRetry', 'filter_block' => 'grid_date_range_filter', ),
					'MailingId' => Array ('title' => 'la_col_MailingList', 'filter_block' => 'grid_range_filter', ),
				),
			),
		),
	);