<?php
/**
* @version	$Id: email_messages_config.php 11906 2009-07-18 00:11:13Z dmitrya $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/
	$config = Array (
		'Prefix' => 'emailmessages',
		'ItemClass' => Array('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
		'ListClass' => Array('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
		'EventHandlerClass' => Array('class' => 'EmailMessagesEventHandler', 'file' => 'email_messages_event_handler.php', 'build_event' => 'OnBuild'),
		'TagProcessorClass' => Array('class' => 'EmailMessageTagProcessor', 'file' => 'email_message_tp.php', 'build_event' => 'OnBuild'),

		'AutoLoad' => true,

		'QueryString' => Array (
			1 => 'id',
			2 => 'page',
			3 => 'event',
			4 => 'mode',
		),

		'IDField' => 'EmailMessageId',
		'TitleField' => 'Subject',

		'TitlePresets' => Array (
			'email_messages_direct_list' => Array (
				'prefixes' => Array ('emailmessages.st_List'), 'format' => "!la_title_EmailMessages!",
				'toolbar_buttons' => Array ('edit', 'view', 'dbl-click'),
				),
			'email_messages_edit_direct' => Array (
				'prefixes' => Array ('emailmessages'),
				'new_status_labels' => Array ('emailmessages' => '!la_title_Adding_E-mail!'),
				'edit_status_labels' => Array ('emailmessages' => '!la_title_Editing_E-mail!'),
				'format' => '#emailmessages_status# - #emailmessages_titlefield#',
				'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit'),
			),
		),

		'Sections' => Array (
			'in-portal:configemail'	=>	Array(
				'parent'		=>	'in-portal:site',
				'icon'			=>	'core:e-mail',
				'label'			=>	'la_tab_E-mails',
				'url'			=>	Array('t' => 'languages/email_message_list', 'pass' => 'm'),
				'permissions'	=>	Array('view', 'edit'),
				'priority'		=>	6,
				'type'			=>	stTREE,
			),
		),

		'TableName' => TABLE_PREFIX.'EmailMessage',

		'ListSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
			 		LEFT JOIN '.TABLE_PREFIX.'Events ON '.TABLE_PREFIX.'Events.EventId = %1$s.EventId'
		),

		'ItemSQLs' => Array (
			'' => '	SELECT %1$s.* %2$s
					FROM %1$s
			 		LEFT JOIN '.TABLE_PREFIX.'Events ON '.TABLE_PREFIX.'Events.EventId = %1$s.EventId'
		),

		'ForeignKey' => 'LanguageId',
		'ParentTableKey' => 'LanguageId',
		'ParentPrefix' => 'lang',
		'AutoDelete' => true,
		'AutoClone' => true,

		'CalculatedFields' => Array (
			'' => Array (
				'Description' => TABLE_PREFIX.'Events.Description',
				'Module' => TABLE_PREFIX.'Events.Module',
				'Type' => TABLE_PREFIX.'Events.Type',
				'ReplacementTags' => TABLE_PREFIX.'Events.ReplacementTags',
			),
		),

		'Fields' => Array (
			'EmailMessageId'	=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Template'			=>	Array('type' => 'string', 'default' => null),
			'MessageType'		=>	Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array('text'=>'la_Text','html'=>'la_Html'), 'use_phrases' => 1, 'not_null' => '1','default' => 'text'),
			'LanguageId'		=>	Array(
				'type' => 'int',
				'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Language ORDER BY PackName', 'option_key_field' => 'LanguageId', 'option_title_field' => 'PackName',
				'not_null' => 1, 'default' => 0
			),
			'EventId'			=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
			'Subject'			=>	Array('type' => 'string', 'default' => null),
		),

		'VirtualFields' => Array (
			'Headers'			=>	Array('type' => 'string', 'default' => ''),
			'Body'				=>	Array('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => ''),
			'ReplacementTags'	=>	Array ('type' => 'string', 'default' => null),
			'Description'		=>	Array('type'=>'string', 'sql_filter_type'=>'having'),
			'Module' 			=>	Array('type' => 'string','not_null' => '1','default' => ''),
			'Type' 				=>	Array('formatter'=>'kOptionsFormatter', 'options' => Array (1 => 'la_Text_Admin', 0 => 'la_Text_User'), 'use_phrases' => 1, 'default' => 0, 'not_null' => 1),

			// for mass mail sending
			'MassSubject'		=>	Array ('type' => 'string', 'default' => ''),
			'MassAttachment'	=>	Array ('type' => 'string', 'formatter' => 'kUploadFormatter', 'upload_dir' => ITEM_FILES_PATH, 'max_size' => 50000000, 'default' => ''),
			'MassHtmlMessage'	=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => 'Type your Message Here'),
			'MassTextMessage'	=>	Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => 'Type your Message Here'),
		),

		'Grids'	=> Array(
			'Default'		=>	Array(
				'Icons' => Array('default'=>'icon16_custom.gif'),
				'Fields' => Array(
					'Subject'		=>	Array( 'title'=>'la_col_Subject', 'filter_block' => 'grid_like_filter'),
					'Description'	=>	Array( 'title'=>'la_col_Description', 'data_block' => 'label_grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
					'Type'			=>	Array( 'title'=>'la_col_Type', 'filter_block' => 'grid_options_filter'),
				),

			),

			'Emails' => Array(
				'Icons' => Array ('default' => 'icon16_custom.gif'),
				'Fields' => Array(
					'EventId' => Array( 'title'=>'la_col_Id', 'filter_block' => 'grid_range_filter'),
					'Subject' => Array( 'title'=>'la_col_Subject', 'filter_block' => 'grid_like_filter'),
					'Description' => Array( 'title'=>'la_col_Description', 'data_block' => 'label_grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
					'Type' => Array( 'title'=>'la_col_Type', 'filter_block' => 'grid_options_filter'),
					'LanguageId' => Array( 'title'=>'la_col_Language', 'filter_block' => 'grid_options_filter'),
				),

			),
		),
	);

?>