<?php
/**
* @version	$Id: config_search_event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	class ConfigSearchEventHandler extends kDBEventHandler  {

		/**
		 * Changes permission section to one from REQUEST, not from config
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$module = $this->Application->GetVar('module');
			$main_prefix = $this->Application->findModule('Name', $module, 'Var');
			$section = $this->Application->getUnitOption($main_prefix.'.search', 'PermSection');
			$event->setEventParam('PermSection', $section);
			return parent::CheckPermission($event);
		}

		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @access protected
		 * @see OnListBuild
		 */
		function SetCustomQuery(&$event)
		{
			$object =& $event->getObject();

			// show only items that belong to selected module
			$module = $this->Application->GetVar('module');
			$object->addFilter('module_filter', '%1$s.ModuleName = '.$this->Conn->qstr($module));

			// don't show disabled search items
			$object->addFilter('active_filter', '%1$s.SimpleSearch <> -1');
		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnUpdate(&$event)
		{
			if (!$this->Application->CheckPermission('SYSTEM_ACCESS.READONLY', 1)) {
				parent::OnUpdate($event);

				$conf_update = new kEvent('conf:OnUpdate');
				$conf_update->redirect = false;
				$this->Application->HandleEvent($conf_update);
			}

			$event->SetRedirectParam('opener', 's');

			// keeps module and section in REQUEST to ensure, that last admin template will work
			$event->SetRedirectParam('module', $this->Application->GetVar('module'));
			$event->SetRedirectParam('module_key', $this->Application->GetVar('module_key'));
			$event->SetRedirectParam('section', $this->Application->GetVar('section'));
		}

		function OnCancel(&$event)
		{
			parent::OnCancel($event);
			$event->SetRedirectParam('opener', 's');
		}

		/**
		 * [HOOK] Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnCreateCustomField(&$event)
		{
			$custom_field =& $event->MasterEvent->getObject();
			if ($custom_field->GetDBField('Type') == 6 || $custom_field->GetDBField('IsSystem') == 1) {
				// user & system custom fields are not searchable
				return false;
			}

			$object =& $event->getObject( Array('skip_autoload' => true) );

			$custom_id = $custom_field->GetID();
			if (!$object->isLoaded() || ($object->GetDBField('CustomFieldId') != $custom_id)) {
				$object->Load($custom_id, 'CustomFieldId');
			}

			$cf_search = Array();
			$element_type = $custom_field->GetDBField('ElementType');

			$cf_search['DisplayOrder'] = $custom_field->GetDBField('DisplayOrder');
			$cf_search['FieldType'] = $element_type;
			$cf_search['DisplayName'] = $custom_field->GetDBField('FieldLabel');
			$cf_search['FieldName'] = $custom_field->GetDBField('FieldName');
			$cf_search['Description'] = $custom_field->GetDBField('Prompt');
			$cf_search['ConfigHeader'] = $custom_field->GetDBField('Heading'); //  'la_Text_CustomFields';
			$cf_search['SimpleSearch'] = in_array($element_type, Array ('text', 'range', 'select', 'multiselect')) ? 1 : 0;
			$cf_search['TableName'] = 'CustomField';

			$sql = 'SELECT Module
					FROM '.TABLE_PREFIX.'ItemTypes
					WHERE ItemType = '.$custom_field->GetDBField('Type');

			$cf_search['ModuleName']	=	$this->Conn->GetOne($sql);

			$object->SetFieldsFromHash($cf_search);
			$object->SetDBField('CustomFieldId', $custom_id);

			$result = $object->isLoaded() ? $object->Update() : $object->Create();
		}
	}

?>