<?php
/**
* @version	$Id: compiler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class NParserCompiler extends kHelper {

	var $Errors = array();
	var $Templates = array();

	function CompileTemplatesStep()
	{
		$templates = $this->Application->RecallVar('templates_to_compile');
		if (!$templates) {
			// build $templates
			$templates = $this->FindTemplates();
		}
		else {
			$templates = unserialize($templates);
		}
		$total = count($templates);
		$current = $this->Application->RecallVar('current_template_to_compile');
		if (!$current) $current = 0;

		if ($errors = $this->Application->RecallVar('compile_errors')) {
			$this->Errors = unserialize($errors);
		}

		$save_handler = $this->Application->errorHandlers[0];
		$this->Application->errorHandlers[0] = array(&$this, 'SaveError');

		safeDefine('DBG_NPARSER_FORCE_COMPILE', 1);
		safeDefine('DBG_IGNORE_FATAL_ERRORS', 1);

		$i = $current;
		$this->Application->InitParser(true);
		while ($i < $total && $i < ($current + 20)) {
			$a_template = $templates[$i];

			$this->Application->Parser->CheckTemplate($a_template['module'] . '/' . $a_template['path']);
			$i++;
		}

		$this->Application->errorHandlers[0] = $save_handler;

		$this->Application->StoreVar('current_template_to_compile', $i);
		$this->Application->StoreVar('templates_to_compile', serialize($templates));
		$this->Application->StoreVar('compile_errors', serialize($this->Errors));
		$res = floor(($current / $total) * 100);
		if ($res == 100 || $current >= $total) {
			$this->Application->RemoveVar('templates_to_compile');
			$this->Application->RemoveVar('current_template_to_compile');
			$this->Application->Redirect($this->Application->GetVar('finish_template'));
		}
		echo $res;
	}

	function SaveError($errno, $errstr, $errfile, $errline, $errcontext)
	{
		if (defined('E_STRICT') && ($errno == E_STRICT)) {
			return true;
		}

		$this->Errors[] = Array ('msg' => $errstr, 'file' => $errfile, 'line' => $errline);
		return true;
	}

	function FindTemplates()
	{
		$this->Templates = Array ();

		// find admin templates
		foreach ($this->Application->ModuleInfo as $module => $options) {
			if ($module == 'In-Portal') {
				// don't check In-Portal admin templates, because it doesn't have them
				continue;
			}

			$template_path = '/' . $options['Path'] . 'admin_templates';
			$options['Path'] = $template_path;

			$this->FindTemplateFiles($template_path, $options);
		}

		// find Front-End templates (from enabled themes only)
		$sql = 'SELECT Name
				FROM ' . $this->Application->getUnitOption('theme', 'TableName') . '
				WHERE Enabled = 1';
		$themes = $this->Conn->GetCol($sql);

		$options = Array ();
		foreach ($themes as $theme_name) {
			$template_path = '/themes/' . $theme_name;
			$options['Name'] = 'theme:' . $theme_name;
			$options['Path'] = $template_path;

			$this->FindTemplateFiles($template_path, $options);
		}

		return $this->Templates;
	}

	function FindTemplateFiles($folderPath, $options)
	{
		// if FULL_PATH = "/" ensure, that all "/" in $folderPath are not deleted
		$reg_exp = '/^'.preg_quote(FULL_PATH, '/').'/';
		$folderPath = preg_replace($reg_exp, '', $folderPath, 1); // this make sense, since $folderPath may NOT contain FULL_PATH

		$fh = opendir(FULL_PATH.$folderPath);
		while (($sub_folder = readdir($fh))) {
			$full_path = FULL_PATH.$folderPath.'/'.$sub_folder;
			$base_name = basename($full_path);
			if (is_dir($full_path) && $base_name != '.' && $base_name != '..') {
				$this->FindTemplateFiles($full_path, $options);
			}
			else {
				$info = pathinfo($full_path);
				if (isset($info['extension']) && $info['extension'] == 'tpl') {
					$this->Templates[] = array('module' => mb_strtolower($options['Name']), 'path' => str_replace(FULL_PATH . $options['Path'] . '/', '', preg_replace('/\.tpl$/', '', $full_path)));
				}
			}
		}
	}


}