<?php
/**
* @version	$Id: event_handler.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

	/**
	 * Note:
	 *   1. When adressing variables from submit containing
	 *	 	Prefix_Special as part of their name use
	 *	 	$event->getPrefixSpecial(true) instead of
	 *	 	$event->Prefix_Special as usual. This is due PHP
	 *	 	is converting "." symbols in variable names during
	 *	 	submit info "_". $event->getPrefixSpecial optional
	 *	 	1st parameter returns correct corrent Prefix_Special
	 *	 	for variables beeing submitted such way (e.g. variable
	 *	 	name that will be converted by PHP: "users.read_only_id"
	 *	 	will be submitted as "users_read_only_id".
	 *
	 *	 2.	When using $this->Application-LinkVar on variables submitted
	 *		from form which contain $Prefix_Special then note 1st item. Example:
	 *		LinkVar($event->getPrefixSpecial(true).'_varname',$event->Prefix_Special.'_varname')
	 *
	 */


	/**
	 * Default event handler. Mostly abstract class
	 *
	 */
	class kEventHandler extends kBase {

		/**
		 * In case if event should be handled with mehod,
		 * which name differs from event name, then it
		 * should be specified here.
		 * key - event name, value - event method
		 *
		 * @var Array
		 * @access protected
		 */
		var $eventMethods = Array();

		/**
		 * Defines mapping vs event names and permission names
		 *
		 * @var Array
		 */
		var $permMapping = Array();

		/**
		 * Define alternative event processing method names
		 *
		 * @see $eventMethods
		 * @access protected
		 */
		function mapEvents()
		{

		}

		/**
		 * Allows to override standart permission mapping
		 *
		 */
		function mapPermissions()
		{

		}

		function getPrefixSpecial()
		{
			trigger_error('Usage of getPrefixSpecial() this method is forbidden in kEventHandler class children. Use $event->getPrefixSpecial(true); instead', E_USER_ERROR);
		}

		/**
		 * Set's prefix and special
		 *
		 * @param string $prefix
		 * @param string $special
		 * @access public
		 */
		function Init($prefix,$special)
		{
			parent::Init($prefix,$special);
			$this->mapEvents();
			$this->mapPermissions();
		}

		/**
		 * Process Event
		 *
		 * @param kEvent $event
		 * @access public
		 */
		function processEvent(&$event)
		{
			$event_name=$event->Name;
			if( isset($this->eventMethods[$event_name]) ) $event_name=$this->eventMethods[$event_name];

			if( method_exists($this,$event_name) )
			{
				$this->$event_name($event);
			}
			else
			{
				trigger_error('event <b>'.$event->Name.'</b> not implemented in class <b>'.get_class($this).'</b>', E_USER_ERROR);
			}
		}

		/**
		 * Sample dummy event
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		function OnBuild(&$event)
		{
			/*echo 'building: <br>';
			print_pre($event);*/
		}

		/**
		 * Returns to previous template in opener stack
		 *
		 * @param kEvent $event
		 */
		function OnGoBack(&$event)
		{
			$url = $this->Application->RecallVar('export_finish_url');
			if ($url) {
				$this->Application->Redirect('external:'.$url);
			}

			$event->SetRedirectParam('opener', 'u');
		}

		/**
		 * Apply some special processing to
		 * object beeing recalled before using
		 * it in other events that call prepareObject
		 *
		 * @param Object $object
		 * @param kEvent $event
		 * @access protected
		 */
		function prepareObject(&$object, &$event)
		{
			// processing here
		}

		/**
		 * Creates new event as child of
		 * event passed as $event param
		 *
		 * @param kEvent $event
		 * @access protected
		 */
		function &inheritEvent(&$event, $name=null)
		{
			$child_event = new kEvent();
			$child_event->MasterEvent =& $event;
			$child_event->Prefix=$event->Prefix;
			$child_event->Special=$event->Special;
			$child_event->Prefix_Special=$event->Prefix_Special;
			$child_event->Name = $name;
			return $child_event;
		}

		/**
		 * Created url part for this module
		 *
		 * @param kEvent $event
		 */
		function BuildEnv(&$event)
		{
			$prefix_special = $event->getPrefixSpecial();
			$url_params = $event->getEventParam('url_params');
			$pass_events = $event->getEventParam('pass_events');

			$query_vars = $this->Application->getUnitOption($event->Prefix, 'QueryString');

			$event_key = array_search('event', $query_vars);
			if ($event_key) {
				// pass through event of this prefix
				unset($query_vars[$event_key]);
			}

			if (!getArrayValue($url_params, $prefix_special.'_event')) {
				// if empty event, then remove it from url
				unset( $url_params[$prefix_special.'_event'] );
			}

			//if pass events is off and event is not implicity passed
			if ( !$pass_events && !isset($url_params[$prefix_special.'_event']) ) {
				unset($url_params[$prefix_special.'_event']); // remove event from url if requested
				//otherwise it will use value from get_var
			}

			if(!$query_vars) return true;

			$processed_params = Array();
			foreach($query_vars as $index => $var_name) {
				//if value passed in params use it, otherwise use current from application
				$var_name = $prefix_special.'_'.$var_name;
				$processed_params[$var_name] =  isset( $url_params[$var_name] ) ? $url_params[$var_name] : $this->Application->GetVar($var_name);
				if ( isset($url_params[$var_name]) ) unset( $url_params[$var_name] );
			}

			$ret = '';

			if (!$processed_params[$prefix_special.'_id']) {
				if ($processed_params[$prefix_special.'_Page'] == 1) {
					// when printing "items" from category, there is 1st page -> nothing from "item prefix" in url
					// and auto-guess pass_category will not be added to url
					$url_params['pass_category'] = 1;
				}
				else {
					$ret .= $processed_params[$prefix_special.'_Page'].'/';
				}
			}

			if ($processed_params[$prefix_special.'_id']) {
				// this allows to fill 3 cache records with one query (see this method for details)
				$category_id = isset($url_params['m_cat_id']) ? $url_params['m_cat_id'] : $this->Application->GetVar('m_cat_id');
				$category_filename = $this->Application->getFilename('c', $category_id);

				// if template is also item template of category, then remove template
				$template = getArrayValue($url_params, 't');

				$mod_rw_helper =& $this->Application->recallObject('ModRewriteHelper');
				/* @var $mod_rw_helper kModRewriteHelper */

				$item_template = $mod_rw_helper->GetItemTemplate($category_id, $event->Prefix);

				if ($template == $item_template || strtolower($template) == '__default__') {
					unset($url_params['t']);
				}

				// get item's filename
				$filename = $this->Application->getFilename($event->Prefix, $processed_params[$prefix_special.'_id'], $category_id );
				if($filename !== false) $ret .= $filename.'/';
			}

			$event->setEventParam('url_params', $url_params);
			$event->setEventParam('env_string', mb_strtolower($ret) );
		}

		/**
		 * Process mod_rewrite url part left after previous parser
		 *
		 * @param kEvent $event
		 */
		function ParseEnv(&$event)
		{
			// <module_page>/<item_filename>

			$url_parts = $event->getEventParam('url_parts');
			$vars = $event->getEventParam('vars');

			$defaults = Array('id' => 0, 'Page' => 1);
			foreach ($defaults as $var_name => $var_value) {
				$this->Application->SetVar($event->getPrefixSpecial().'_'.$var_name, $var_value);
				$vars[$event->getPrefixSpecial().'_'.$var_name] = $var_value;
			}

			if (!$url_parts) {
//				$event->status = erFAIL;
				return false;
			}

			$ret = '';
			$url_part = array_shift($url_parts);

			// match module page
			if ( is_numeric($url_part) ) {
				$this->Application->SetVar( $event->getPrefixSpecial().'_Page', $url_part);
				$vars[$event->getPrefixSpecial().'_Page'] = $url_part;
				$url_part = $url_parts ? array_shift($url_parts) : '';
			}

			if (!$url_part) {
				$event->setEventParam('url_parts', $url_parts);
//				$event->status = erFAIL;
				return true;
			}

			// match item's filename
			$db =& $this->Application->GetADODBConnection();
			$id_field = $this->Application->getUnitOption($event->Prefix, 'IDField');
			$table = $this->Application->getUnitOption($event->Prefix, 'TableName');

			$sql = 'SELECT item_table.'.$id_field.'
					FROM '.$table.' item_table
					LEFT JOIN '.TABLE_PREFIX.'CategoryItems cat_items ON item_table.ResourceId = cat_items.ItemResourceId
					WHERE (item_table.Filename = '.$db->qstr($url_part).') AND (cat_items.CategoryId = '.$this->Application->GetVar('m_cat_id').')';

			$item_id = $db->GetOne($sql);
			if ($item_id !== false) {
				$this->Application->SetVar($event->getPrefixSpecial().'_id', $item_id);
				$vars[$event->getPrefixSpecial().'_id'] = $item_id;
			}
			elseif ($url_part !== 'index') {
				// otherwise category/index.html is parsed as /index.tpl
				array_unshift($url_parts, $url_part);
				$event->status = erFAIL;
			}

			$event->setEventParam('url_parts', $url_parts);
			$event->setEventParam('vars', $vars);
		}

		/**
		 * Checks permissions of user
		 *
		 * @param kEvent $event
		 */
		function CheckPermission(&$event)
		{
			$perm_helper =& $this->Application->recallObject('PermissionsHelper');
			return $perm_helper->CheckEventPermission($event, $this->permMapping);
		}

		/**
		 * Occurs, when config was parsed, allows to change config data dynamically
		 *
		 * @param kEvent $event
		 */
		function OnAfterConfigRead(&$event)
		{
			// readonly, for hooking only!
		}

	}


?>