<?php
	ob_start();
?>
<tr class="table-color2">
	<td class="text" colspan="2" valign="middle">
		<table cellpadding="0" cellspacing="0">
			<tr>
				<td valign="top">
					<input type="checkbox" %3$s name="modules[]" id="module_%1$s" value="%1$s"/>
				</td>
				<td valign="top">
					<label for="module_%1$s">%2$s</label>
					<div style="font-weight: bold; color: red;">%4$s</div>
				</td>
			</tr>
		</table>
	</td>
</tr>
<?php
	$module_tpl = ob_get_clean();

	$selected = $this->GetVar('modules') ? $this->GetVar('modules') : Array ('core');
	$modules = $this->GetUpgradableModules();
	foreach ($modules as $module_name => $module_params) {
		$module_name = strtolower($module_name);
		$upgrade_versions = Array (
			$module_params['Version'],
			$module_params['ToVersion'],
		);
		$prerequisites_errors = $this->toolkit->CheckPrerequisites($module_params['Path'], $upgrade_versions, 'upgrade');

		$module_title = $this->toolkit->getModuleName($module_name).' ('.$module_params['Version'].' to '.$module_params['ToVersion'].')';
		if ($this->Application->isDebugMode()) {
			$module_title .= ' [from: '.$module_params['FromVersion'].']';
		}

		if ($prerequisites_errors) {
			// disable checkbox, when some of prerequisites not passed
			$checked = 'disabled';
		}
		else {
			// preserve user selected checked status
			$checked = in_array($module_name, $selected) ? 'checked="checked"' : '';
		}

		$error_msg = $prerequisites_errors ? implode('<br />', $prerequisites_errors) : '';

		echo sprintf($module_tpl, $module_name, $module_title, $checked, $error_msg);
	}
?>
<tr class="table-color1">
	<td class="hint" colspan="2" valign="middle">
		<img src="incs/img/icon_warning.gif" width="14" height="14" align="absmiddle" />
		Your data will be modified during the upgrade. We strongly recommend that you make a backup of your database. Proceed with the upgrade ?
	</td>
</tr>