<?php
/**
* @version	$Id: phrases_cache.php 11892 2009-07-01 08:35:06Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.net/license/ for copyright notices and details.
*/

class PhrasesCache extends kBase {

	/**
	* Connection to database
	*
	* @var kDBConnection
	* @access public
	*/
	var $Conn;

	var $Phrases = Array();
	var $Ids = Array();
	var $OriginalIds = Array(); //for comparing cache

	var $LanguageId = null;

	var $fromTag = false;

	function PhrasesCache()
	{
		parent::kBase();
		$this->Conn =& $this->Application->GetADODBConnection();
	}

	function Init($prefix, $special = '')
	{
		if (constOn('IS_INSTALL')) {
			$this->LanguageId = 1;
		}
		else {
			if ($this->Application->IsAdmin()) {
				$id_field = $this->Application->getUnitOption('lang', 'IDField');
				$table_name = $this->Application->getUnitOption('lang', 'TableName');
				$sql = 'SELECT '.$id_field.'
						FROM '.$table_name.'
						WHERE AdminInterfaceLang = 1';
				$this->LanguageId = $this->Conn->GetOne($sql);
			}
			else {
				$this->LanguageId = $this->Application->GetVar('m_lang');
			}
		}

		if (isset($this->Application->Caches['PhraseList'])) {
			$this->LoadPhrases( $this->Application->Caches['PhraseList'] );
		}
	}

	function GetCachedIds()
	{
		$query = sprintf("SELECT PhraseList, ConfigVariables FROM %s WHERE Template = %s",
											TABLE_PREFIX.'PhraseCache',
											$this->Conn->Qstr(md5($this->Application->GetVar('t').$this->Application->GetVar('m_theme').$this->Application->GetVar('m_lang'))));
		$res = $this->Conn->GetRow($query);

		if ($res && $res['ConfigVariables']) {
			$this->Application->OriginalConfigCacheIds =  explode(',', $res['ConfigVariables']);
			$this->Application->ConfigCacheIds = $this->Application->OriginalConfigCacheIds;
		}

		return ($res === false) ? Array() : explode(',', $res['PhraseList']);
	}

	function LoadPhrases($ids)
	{
		if ( !is_array($ids) || !implode('', $ids) ) return;
		$query = sprintf("SELECT Translation,UPPER(Phrase) AS Phrase FROM %s WHERE LanguageId = %s AND PhraseId IN (%s)",
											TABLE_PREFIX.'Phrase',
											$this->LanguageId,
											join(',', $ids));
		$this->Phrases = $this->Conn->GetCol($query,'Phrase');
		/*foreach($phrases as $phrase => $tanslation)
		{
			$this->AddCachedPhrase(mb_strtoupper($phrase), $tanslation);
		}*/
		$this->Ids = $ids;
		$this->OriginalIds = $ids;
	}

	function AddCachedPhrase($label, $value)
	{
		$label = mb_strtoupper($label);
		$this->Phrases[$label] = $value;
	}

	function NeedsCacheUpdate()
	{
		return is_array($this->Ids) && count($this->Ids) > 0 && $this->Ids != $this->OriginalIds;
	}

	/**
	 * Copy from Application->UpdateCache method
	 *
	 * @deprecated
	 */
	function UpdateCache()
	{
		$update = false;
		//something changed
		$update = $update || (is_array($this->Ids) && count($this->Ids) > 0 && $this->Ids != $this->OriginalIds);
		$update = $update || (count($this->Application->ConfigCacheIds) && $this->Application->ConfigCacheIds != $this->Application->OriginalConfigCacheIds);
		if ($update) {
			$query = sprintf("REPLACE %s (PhraseList, CacheDate, Template, ConfigVariables)
												VALUES (%s, %s, %s, %s)",
												TABLE_PREFIX.'PhraseCache',
												$this->Conn->Qstr(join(',', $this->Ids)),
												adodb_mktime(),
												$this->Conn->Qstr(md5($this->Application->GetVar('t').$this->Application->GetVar('m_theme').$this->Application->GetVar('m_lang'))),
												$this->Conn->qstr(implode(',', array_unique($this->Application->ConfigCacheIds))));
			$this->Conn->Query($query);
		}
	}

	function GetPhrase($label)
	{
		if (!isset($this->LanguageId)) return 'impossible case';
		//actually possible when custom field contains references to language labels and its being rebuilt in OnAfterConfigRead
		//which is triggered by Sections rebuild, which in turn read all the configs and all of that happens BEFORE seeting the language...

		if (ereg("^!.+!$", $label) > 0)
		{
			$label = substr($label, 1, -1); //cut exclamation marks
		}

		if( strlen($label) == 0 ) return '';

		$original_label = $label;
		$label = mb_strtoupper($label);
		if(isset($this->Phrases[$label])) {
			$translated_label = $this->Phrases[$label];
			// debug mode is checked directly to improve performance
			if (defined('DEBUG_MODE') && DEBUG_MODE && constOn('DBG_PHRASES_HIGHLIGHT')) {
				if (!$this->Application->isDebugMode()) return $translated_label;

				if ($this->Application->IsAdmin()) {
					$sql = 'SELECT Module
							FROM '.TABLE_PREFIX.'Phrase
							WHERE (LanguageId = '.$this->LanguageId.') AND (Phrase = '.$this->Conn->qstr($label).')';
					$this->Application->Debugger->appendHTML('Phrase: <b>'.$label.'</b>; Module: <b>'.$this->Conn->GetOne($sql).'</b>');
//					$translated_label = $translated_label.' [m: '.$this->Conn->GetOne($sql).'; l: '.$label.']';
				}
				else {
					// highlight text created via translated phrase (used to detect if text on screen is phrase or not)
					$translated_label = '<span style="border: 1px solid #999999; background-color: #cccccc; color: #999999; ">'.$translated_label.'</span></a> <span style="color: red; background-color:#ffffcc">'.$original_label.'</span>';
				}

			}

			if (defined('DEBUG_MODE') && DEBUG_MODE &&
					(($this->Application->IsAdmin() && constOn('DBG_PHRASES_EDIT_ADMIN')) || (!$this->Application->IsAdmin() && constOn('DBG_PHRASES_EDIT_FRONT')) ) ) {
				// option to change translation for Labels
				list($edit_tpl, $index_file) = $this->Application->IsAdmin() ? Array('regional/phrases_edit', 'index.php') : Array('phrases_edit', 'index.php');

				if ($this->Application->IsAdmin() && $this->Application->ConfigValue('UsePopups')) {
					// link to popup when using popups (only in admin)
					$edit_url = 'javascript:translate_phrase(\''.addslashes($translated_label).'\', \''.$edit_tpl.'\');';
				}
				else {
					// direct link, when not using popups OR on frontend
					$edit_url = $this->Application->HREF($edit_tpl,'',Array('m_opener'=>'d','phrases_label'=>$original_label,'phrases_event'=>'OnPrepareUpdate', 'pass'=>'all,phrases'), $index_file );
				}
				$translated_label = '<a href="'.$edit_url.'">!'.$translated_label.'!</a>';
			}

			return $translated_label;
		}

		$this->LoadPhraseByLabel($label, $original_label);
		return $this->GetPhrase($label);
	}

	function LoadPhraseByLabel($label, $original_label)
	{
		$query = sprintf("SELECT PhraseId, Translation FROM %s WHERE LanguageId = %s AND UPPER(Phrase) = UPPER(%s)",
											TABLE_PREFIX.'Phrase',
											$this->LanguageId,
											$this->Conn->qstr($label));
		$res = $this->Conn->GetRow($query);
		if ($res === false || count($res) == 0)
		{
			$translation = '!'.$label.'!';
			if($this->Application->isDebugMode() && constOn('DBG_PHRASES')) {
				list($edit_tpl, $index_file) = $this->Application->IsAdmin() ? Array('regional/phrases_edit', 'index.php') : Array('phrases_edit', 'index.php');

				if ($this->Application->IsAdmin() && $this->Application->ConfigValue('UsePopups')) {
					// link to popup when using popups (only in admin)
					$edit_url = 'javascript:translate_phrase(\''.addslashes($original_label).'\', \''.$edit_tpl.'\');';
				}
				else {
					// direct link, when not using popups OR on frontend
					$edit_url = $this->Application->HREF($edit_tpl,'',Array('m_opener'=>'d','phrases_label'=>$original_label,'phrases_event'=>'OnNew', 'pass'=>'all,phrases'), $index_file );
				}

				$translation = '<a href="'.$edit_url.'">!'.$label.'!</a>';
				if($this->fromTag) $translation = $this->escapeTagReserved($translation);
			}
			$this->AddCachedPhrase($label, $translation); //add it as already cached, as long as we dont need to cache not found phrase
			return false;
		}

		$this->Phrases[$label] = $res['Translation'];
		array_push($this->Ids, $res['PhraseId']);
		$this->Ids = array_unique($this->Ids); //just to make sure
		return true;
	}

	/**
	 * Sort params by name and then by length
	 *
	 * @param string $a
	 * @param string $b
	 * @return int
	 * @access private
	 */
	function CmpParams($a, $b)
	{
		$a_len = mb_strlen($a);
		$b_len = mb_strlen($b);
		if ($a_len == $b_len) return 0;
		return $a_len > $b_len ? -1 : 1;
	}

	/**
	 * Replace language tags in exclamation marks found in text
	 *
	 * @param string $text
	 * @param bool $force_escape force escaping, not escaping of resulting string
	 * @return string
	 * @access public
	 */
	function ReplaceLanguageTags($text,$forse_escaping=null)
	{
		$this->fromTag = true;
		if( isset($forse_escaping) ) $this->fromTag = $forse_escaping;
		preg_match_all("(!(la|lu)[^!]+!)", $text, $res, PREG_PATTERN_ORDER);
		$language_tags = $res[0];
		uasort($language_tags, Array(&$this, 'CmpParams') );

		$values = Array();
		$i = 0;
		foreach ($language_tags as $label) {
			array_push($values, $this->GetPhrase($label) );
			//array_push($values, $this->Application->Phrase($label) );
			$language_tags[$i] = '/' . $language_tags[$i] . '/';
			$i++;
		}
		$this->fromTag = false;
		return preg_replace($language_tags, $values, $text);
	}

	/**
	 * Escape chars in phrase translation, that could harm parser to process tag
	 *
	 * @param string $text
	 * @return string
	 * @access private
	 */
	function escapeTagReserved($text)
	{
		$reserved = Array('"',"'"); // =
		$replacement = Array('\"',"\'"); // \=
		return str_replace($reserved,$replacement,$text);
	}

}


?>