function TemplateManager ($edit_url, $browse_url, $save_layout_url, $edting_mode) {
	this._editUrl = $edit_url;
	this.browseUrl = $browse_url;
	this._saveLayoutUrl = $save_layout_url;
	this.editingMode = $edting_mode; // from 1 to 4

	this._blocks = {};

	this._blockOrder = Array ();

	var $template_manager = this;

	$(document).ready(
		function() {
			$template_manager.searchBlocks();

			if (!$template_manager.editingMode) {
				return ;
			}

			// show special toolbar when in any of 4 browse modes
			var $head_frame = getFrame('head');
			var $extra_toolbar = $head_frame.$('div.front-extra-toolbar').clone(); // clone to keep original untouched

			$('a', $extra_toolbar).each(
				function() {
					// cut from end, because IE7 adds base_href to beginning of href
					var $editing_mode = $(this).attr('href');
					$editing_mode = $editing_mode.substr($editing_mode.length - 1, 1);

					$(this).attr('href', $template_manager.browseUrl.replace('#EDITING_MODE#', $editing_mode));

					if ($editing_mode == $template_manager.editingMode) {
						$(this).parents('td:first').addClass('button-active').prevAll('td:first').addClass('button-active');
					}
				}
			);

			$head_frame.$('#extra_toolbar').html( $extra_toolbar.html() );

			if ($template_manager.editingMode == 2) {
				// Layout Mode

				$template_manager.renumberMovableElements();

				$('div.movable-area').sortable(
					{
						placeholder: 'move-helper',
						handle: '.movable-header',
						items: 'div.movable-element',
						connectWith: ['div.movable-area'],
						tolerance: 'pointer',
						start: function(e, ui) {
							ui.placeholder.height( ui.item.height() );
						}
					}
				);
			}

			$('div.cms-edit-btn')
			.mouseover(
				function(e) {
					$(this).css('opacity', 1);
				}
			)
			.mouseout(
				function(e) {
					$(this).css('opacity', 0.5);
				}
			);
		}
	);
}

TemplateManager.prototype.renumberMovableElements = function () {
	var $area_index = 0;
	// 1. dynamically assign IDs to all movable elements
	$('div.movable-area').each(
		function() {
			var $element_index = 0;
			$('div.movable-element', this).each(
				function() {
					$(this).attr('id', 'target_order_a' + $area_index + 'e' + $element_index);
					$element_index++;
				}
			);

			$area_index++;
		}
	);
}

TemplateManager.prototype.saveLayout = function () {
	// prepare order string
	var $sort_order = [];
	$('div.movable-area').each(
		function($area_index) {
			var $order = $(this).sortable('serialize').replace(/target_order\[\]/g, 'target_order[' + $area_index + '][]');
			if ($order) {
				$sort_order.push($order);
			}
		}
	);
	$sort_order = $sort_order.join('&');

	// save order string
	var $me = this;

	var $settings = {
		url: this._saveLayoutUrl + '&' + $sort_order + '&width=200&height=70&modal=true',
		caption: 'Layout Saving Result',
		onDataReceived: function ($data) {
			var $message = '';

			if ($data == 'OK') {
				$message = 'New Layout Saved';
				$me.renumberMovableElements();
			}
			else {
				$message = 'Failed to Save New Layout';
			}

			$data = '<div style="text-align: center;">' + $message + '<br/><br/><input type="button" class="button" value="OK" onclick="TB.remove();"/></div>';

			return $data;
		}
	};

	TB.setWindowTitle( window.top.document.title.replace(main_title + ' :: ', '') );
	TB.show($settings);
}

TemplateManager.prototype.onBtnClick = function ($e, $element) {
	var $id = $element.id.replace(/_btn$/, '');
	var $block_info = this._blocks[$id];
	var $url = this._editUrl.replace('#BLOCK#', $block_info.block_name + ':' + $block_info.function_name).replace('#EVENT#', 'OnLoadBlock');

	openSelector('theme-file', $url);

	$e.stopPropagation();
}

TemplateManager.prototype.onMouseOver = function ($e, $element) {
	$($element).addClass('block-edit-btn-container-over');
	$e.stopPropagation();
}

TemplateManager.prototype.onMouseOut = function ($e, $element) {
	$($element).removeClass('block-edit-btn-container-over');
	$e.stopPropagation();
}

TemplateManager.prototype.searchBlocks = function () {
	$('div').each (
		function () {
			var $id = $(this).attr('id');

			if (!$id || $id.match(/parser_block\[.*\].*_btn$/) || !$id.match(/parser_block\[.*\]/)) {
				// skip other divs
				return true;
			}

			TemplateManager.prototype.registerBlock.call(aTemplateManager, this);
		}
	);
}

TemplateManager.prototype.registerBlock = function ($element) {
	var $params = $element.getAttribute('params').split(':');

	this._blocks[$element.id] = {
		block_name: $params[0],
		function_name: $params[1]
	};

	var $btn = document.getElementById($element.id + '_btn');

	$($btn).bind(
		'click',
		function(ev) {
			TemplateManager.prototype.onBtnClick.call(aTemplateManager, ev, this);
		}
	);

	$($element).bind(
		'mouseover',
		function(ev) {
			TemplateManager.prototype.onMouseOver.call(aTemplateManager, ev, this);
		}
	);

	$($element).bind(
		'mouseout',
		function(ev) {
			TemplateManager.prototype.onMouseOut.call(aTemplateManager, ev, this);
		}
	);

	this._blockOrder.push($element.id);
}