<?php
/**
* @version	$Id: theme_item.php 16583 2017-07-18 11:34:35Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class ThemeItem extends kDBItem
	{
		public function Load($id, $id_field_name = null, $cachable = true)
		{
			if ( $cachable && $this->IsTempTable() ) {
				$cachable = false;
			}

			$default = false;
			if ($id == 'default') {
				// domain based primary theme
				$id = $this->Application->siteDomainField('PrimaryThemeId');

				if (!$id) {
					$id = 1;
					$id_field_name = 'PrimaryTheme';
				}

				$default = true;
			}

			$res = parent::Load($id, $id_field_name, $cachable);

			if ($res) {
				$available_themes = $this->Application->siteDomainField('Themes');

				if ($available_themes) {
					if (strpos($available_themes, '|' . $this->GetID() . '|') === false) {
						// theme isn't allowed in site domain
						return $this->Clear();
					}
				}
			}

			if ($default) {
				if (!$res) {
					if ($this->Application->isAdmin) {
						$res = parent::Load(1, $id_field_name, false);
					}
				}
				$this->Application->SetVar('theme.current_id', $this->GetID() );
				$this->Application->SetVar('m_theme', $this->GetID() );
			}

			return $res;
		}

		/**
		 * Returns full path to stylesheet file.
		 *
		 * @param boolean $as_url Allows to return url to stylesheet file instead of it's path.
		 *
		 * @return string|boolean
		 */
		public function getStylesheetFile($as_url = false)
		{
			$stylesheet_file = ltrim($this->GetDBField('StylesheetFile') ?: 'inc/style.css', '/');

			$theme_path = FULL_PATH . '/themes/' . $this->GetDBField('Name');
			$stylesheet_file = $theme_path . '/' . $stylesheet_file;

			if ( !file_exists($stylesheet_file) ) {
				return false;
			}

			if ( $as_url ) {
				/** @var FileHelper $file_helper */
				$file_helper = $this->Application->recallObject('FileHelper');

				return $file_helper->pathToUrl($stylesheet_file);
			}

			return $stylesheet_file;
		}
	}
