<?php
/**
* @version	$Id: related_searches_event_handler.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class RelatedSearchEventHandler extends kDBEventHandler
	{
		/**
		 * Prepares new kDBItem object
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnNew(kEvent $event)
		{
			parent::OnNew($event);

			/** @var kDBItem $object */
			$object = $event->getObject();

			$table_info = $object->getLinkedInfo();

			$source_itemtype = $this->Application->getUnitOption($table_info['ParentPrefix'], 'ItemType');
			$object->SetDBField('ItemType', $source_itemtype);
		}

	}