<?php
/**
* @version	$Id: filters_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'item-filter',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'ItemFilterEventHandler', 'file' => 'item_filter_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'ItemFilterTagProcessor', 'file' => 'item_filter_tp.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'FilterId',

	'TableName' => TABLE_PREFIX . 'ItemFilters',

	'TitleField' => 'FilterField',
	'StatusField' => Array ('Enabled'),

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('item-filter' => '!la_title_AddingItemFilter!'),
			'edit_status_labels' => Array ('item-filter' => '!la_title_EditingItemFilter!'),
		),

		'item_filter_list' => Array (
			'prefixes' => Array ('item-filter_List'), 'format' => "!la_title_ItemFilters!",
			'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'view', 'dbl-click'),
		),

		'item_filter_edit' => Array (
			'prefixes' => Array ('item-filter'), 'format' => "#item-filter_status# '#item-filter_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:item_filters'),

	'Sections' => Array (
		'in-portal:item_filters' => Array (
			'parent' => 'in-portal:website_setting_folder',
			'icon' => 'filters',
			'label' => 'la_title_ItemFilters',
			'url' => Array ('t' => 'item_filters/item_filter_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 14,
			'type' => stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'CalculatedFields' => Array (
		'' => Array (
			'FilterKey' => 'CONCAT(%1$s.ItemPrefix, "_", %1$s.FilterField)',
		),
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('FilterId' => 'asc'),
		)
	),

	'Fields' => Array (
		'FilterId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'ItemPrefix' => Array (
			'type' => 'string', 'max_len' => 255,
			'error_msgs' => Array ('not_registered' => '!la_error_InvalidItemPrefix!'),
			'not_null' => 1, 'required' => 1, 'default' => ''
		),
		'FilterField' => Array (
			'type' => 'string', 'max_len' => 255,
			'error_msgs' => Array ('non_existing' => '!la_error_InvalidFieldName!'),
			'not_null' => 1, 'required' => 1, 'default' => ''
		),
		'FilterType' => Array (
			'type' => 'string', 'max_len' => 100,
			'formatter' => 'kOptionsFormatter', 'options' => Array ('text' => 'la_type_text', 'select' => 'la_type_select', 'radio' => 'la_type_radio', 'checkbox' => 'la_type_checkbox', 'range' => 'la_type_RangeSlider'), 'use_phrases' => 1,
			'not_null' => 1, 'required' => 1, 'default' => ''
		),
		'Enabled' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 1
		),
		'RangeCount' => Array ('type' => 'int', 'default' => NULL),
	),

	'VirtualFields' => Array (
		'FilterKey' => Array ('type' => 'string', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array ('default' => 'icon16_item.png', 0 => 'icon16_disabled.png'),
			'Fields' => Array (
				'FilterId' => Array ('title' => 'column:la_fld_Id', 'filter_block' => 'grid_range_filter'),
				'ItemPrefix' => Array ('filter_block' => 'grid_like_filter'),
				'FilterField' => Array ('filter_block' => 'grid_like_filter'),
				'FilterType' => Array ('filter_block' => 'grid_options_filter'),
				'Enabled' => Array ('filter_block' => 'grid_options_filter'),
				'RangeCount' => Array ('filter_block' => 'grid_range_filter'),
			)
		)
	)
);