<?php
/**
* @version	$Id: visits_tag_processor.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class VisitsTagProcessor extends kDBTagProcessor {

		function UserFound($params)
		{
			$virtual_users = Array(USER_ROOT, USER_GUEST, 0);

			/** @var kDBItem $object */
			$object = $this->getObject($params);

			return !in_array( $object->GetDBField( $params['user_field'] ) , $virtual_users );
		}

		/**
		 * Returns link for user editing
		 *
		 * @param Array $params
		 *
		 * @return string
		 * @access protected
		 */
		protected function UserLink($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			$user_id = $object->GetDBField( $params['user_field'] );

			if (!$user_id) {
				return '';
			}

			$url_params =  Array (
				'm_opener' => 'd',
				'u_mode' => 't',
				'u_event' => 'OnEdit',
				'u_id' => $user_id,
				'pass' => 'all,u'
			);

			return $this->Application->HREF($params['edit_template'], '', $url_params);
		}

		function getDateLimitClause($field)
		{
			$search_filter = $this->Application->RecallVar( $this->getPrefixSpecial().'_search_filter');
			if($search_filter)
			{
				$search_filter = unserialize($search_filter);
				return $search_filter[$field]['value'];
			}
			return '';
		}

		function AffiliateOrderInfo($params)
		{
			$list =& $this->GetList($params);

			$date_limit = str_replace($list->TableName, 'vis', $this->getDateLimitClause('VisitDate') );

			$affil_table = $this->Application->getUnitOption('affil', 'TableName');
			$affil_idfield = $this->Application->getUnitOption('affil', 'IDField');
			$sql = 'SELECT '.$affil_idfield.' FROM '.$affil_table.' WHERE PortalUserId = '.$this->Application->RecallVar('user_id');
			$affiliate_id = $this->Conn->GetOne($sql);

			$sql = 'SELECT COUNT(ord.OrderId) AS OrderCount
					FROM '.$list->TableName.' vis
					LEFT JOIN '.TABLE_PREFIX.'Orders ord ON ord.VisitId = vis.VisitId
					WHERE (vis.AffiliateId = '.$affiliate_id.') AND (ord.Status = '.ORDER_STATUS_PROCESSED.')'.($date_limit ? ' AND '.$date_limit : '');

			$result = $this->Conn->GetRow($sql);

			$sql = 'SELECT COUNT(*) FROM '.$list->TableName.' vis
					WHERE AffiliateId = '.$affiliate_id.($date_limit ? ' AND '.$date_limit : '');

			$result['TotalVisitors'] = $this->Conn->GetOne($sql);
			$result['OrderTotalAmount'] = $list->getTotal('OrderTotalAmount', 'SUM');
			$result['OrderAffiliateCommission'] = $list->getTotal('OrderAffiliateCommission', 'SUM');

			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $params['render_as'];

			$format_fields = Array('OrderTotalAmount', 'OrderAffiliateCommission');

			if (array_key_exists('currency', $params) && $params['currency']) {
				$iso = $this->GetISO($params['currency']);
				foreach($format_fields as $format_field)
				{
					$format = $list->GetFieldOption($format_field, 'format');
					$value = sprintf($format, $result[$format_field]);
					$value = $this->ConvertCurrency($value, $iso);
					$value = $this->AddCurrencySymbol($value, $iso);
					$result[$format_field] = $value;
				}
			}

			$block_params = array_merge($block_params, $result);

			return $this->Application->ParseBlock($block_params);
		}

		function ListVisitors($params)
		{
			$o = '';

			$params['render_as'] = $params['item_render_as'];

			$o_visitors = $this->PrintList2($params);

			if($o_visitors)
			{
				$header = '';
				$footer = '';

				$block_params = $this->prepareTagParams($params);

				$header_block = getArrayValue($params, 'header_render_as');
				if($header_block)
				{
					$block_params['name'] = $header_block;
					$header = $this->Application->ParseBlock($block_params);
				}

				$footer_block = getArrayValue($params, 'footer_render_as');
				if($footer_block)
				{
					$block_params['name'] = $footer_block;
					$footer = $this->Application->ParseBlock($block_params);
				}

				$o = $header.$o_visitors.$footer;
			}
			else
			{
				$visitors_params = array('name' => $params['empty_myvisitors_render_as']);
				$o = $this->Application->ParseBlock($visitors_params);
			}

			return $o;

		}

		/**
		 * Enter description here...
		 *
		 * @param string $params
		 * @return kDBList
		 */
		function &GetList($params)
		{
			$list_name = array_key_exists('list_name', $params) ? $params['list_name'] : '';

			if ( !$list_name ) {
				$list_name = $this->Application->Parser->GetParam('list_name');
			}

			$types = $this->SelectParam($params, 'types');

			if ( $types == 'myvisitororders' || $types == 'myvisitors' ) {
				$this->nameToSpecialMapping[$list_name] = 'incommerce';
			}

			return parent::GetList($params);
		}
	}
