<?php
/**
* @version	$Id: permission_types_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'permission-type',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'PermissionTypeEventHandler', 'file' => 'permission_type_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'event',
		4 => 'mode',
	),

	'IDField' => 'PermissionConfigId',

	'TableName' => TABLE_PREFIX . 'CategoryPermissionsConfig',

	'TitleField' => 'PermissionName',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('permission-type' => '!la_title_AddingPermissionType!'),
			'edit_status_labels' => Array ('permission-type' => '!la_title_EditingPermissionType!'),
		),

		'permission_type_list' => Array ('prefixes' => Array ('permission-type_List'), 'format' => "!la_tab_PermissionTypes! (#permission-type_recordcount#)"),
		'permission_type_edit' => Array ('prefixes' => Array ('permission-type'), 'format' => "#permission-type_status# '#permission-type_titlefield#'"),
	),

	'PermSection' => Array ('main' => 'in-portal:permission_types'),

	'Sections' => Array (
		'in-portal:permission_types' => Array (
			'parent' => 'in-portal:website_setting_folder',
			'icon' => 'permission_types',
			'label' => 'la_tab_PermissionTypes',
			'url' => Array ('t' => 'permission_types/permission_type_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 13,
			'type' => stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('PermissionName' => 'asc'),
		)
	),

	'Fields' => Array (
		'PermissionConfigId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'PermissionName' => Array (
			'type' => 'string', 'max_len' => 30,
			'not_null' => 1, 'unique' => Array (), 'required' => 1, 'default' => '',
		),
		'Description' => Array (
			'type' => 'string', 'max_len' => 255,
			'formatter' => 'kFormatter', 'regexp' => '/^(la|lu|lc)_[A-Z\d:_\-\.]+$/i',
			'not_null' => 1, 'required' => 1, 'default' => '',
		),
		'ModuleId' => Array (
			'type' => 'string', 'max_len' => 20,
			'formatter' => 'kOptionsFormatter', 'options' => Array ('Admin' => 'Admin', 'Front' => 'Front'), 'options_sql' => 'SELECT Name AS Id, Name FROM ' . TABLE_PREFIX . 'Modules', 'option_key_field' => 'Id', 'option_title_field' => 'Name',
			'not_null' => 1, 'required' => 1, 'default' => '',
		),
		'IsSystem' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes',  0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
	),

	'Grids' => Array (
		'Default' => Array (
			'Fields' => Array (
				'PermissionConfigId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 80),
				'PermissionName' => Array ('title' => 'column:la_fld_Name', 'filter_block' => 'grid_like_filter', 'width' => 225),
				'Description' => Array ('filter_block' => 'grid_like_filter', 'as_label' => 1, 'width' => 225),
				'ModuleId' => Array ('title' => 'column:la_fld_Module', 'filter_block' => 'grid_options_filter'),
				'IsSystem' => Array ('filter_block' => 'grid_options_filter'),
			),
		),
	),
);