<?php
/**
* @version	$Id: mailing_list_tp.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class MailingListTagProcessor extends kDBTagProcessor {

		function PrintRecipients($params)
		{
			/** @var kDBItem $object */
			$object = $this->getObject($params);

			/** @var MailingListHelper $mailing_list_helper */
			$mailing_list_helper = $this->Application->recallObject('MailingListHelper');

			// for each group convert ids to names
			$recipient_names = Array ();
			$recipients_grouped = $mailing_list_helper->groupRecipientsByType(explode(';', $object->GetDBField('To')));

			foreach ($recipients_grouped as $recipient_type => $group_recipients) {
				$recipient_names = array_merge($recipient_names, $mailing_list_helper->getRecipientNames($recipient_type, $group_recipients));
			}

			$ret = '';
			$recipient_count = count($recipient_names);
			$block_params = $this->prepareTagParams($params);
			$block_params['name'] = $params['render_as'];

			foreach ($recipient_names as $recipient_index => $recipient_name) {
				$block_params['recipient_name'] = $recipient_name;
				$block_params['not_last'] = $recipient_index < $recipient_count - 1;

				$ret .= $this->Application->ParseBlock($block_params);
			}

			return $ret;
		}

		function IsManualRecipient($params)
		{
			$external_call = $this->Application->GetVar('mailing_recipient_type');

			if ($external_call) {
				return false;
			}

			/** @var kDBItem $object */
			$object = $this->getObject($params);

			return $object->IsNewItem();
		}
	}