
(function()
{
	CKEDITOR.plugins.add( 'my_inline', {
		init: function (editor) {
			var lang = editor.lang;

			editor.addCommand('inline-save', {
				modes: { wysiwyg: 1, source: 1 },
				editorFocus: false,
				exec: function () {
					$(editor.element.$).data('no_save_on_blur', null).trigger('blur');
					editor.focusManager.blur();
				},
				canUndo: false
			});

			editor.addCommand('inline-cancel', {
				modes: { wysiwyg: 1, source: 1 },
				editorFocus: false,
				exec: function () {
					$(editor.element.$).data('no_save_on_blur', true).trigger('blur');
					editor.focusManager.blur();
				},
				canUndo: false
			});

			editor.ui.addButton('InlineSave', {
				label: lang.save.toolbar,
				command: 'inline-save',
				icon: 'save'
			});

			editor.ui.addButton('InlineCancel', {
				label: lang.common.close,
				command: 'inline-cancel',
				icon: this.path + 'images/cancel.png'
			});
		}
	} );
})();
