<?php
/**
* @version	$Id: users_config.php 16584 2017-07-18 11:36:52Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'u',
	'ItemClass' => Array ('class' => 'UsersItem', 'file' => 'users_item.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'UsersEventHandler', 'file' => 'users_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'UsersTagProcessor', 'file' => 'users_tag_processor.php', 'build_event' => 'OnBuild'),

	'RegisterClasses' => Array (
		Array ('pseudo' => 'UsersSyncronizeManager', 'class' => 'UsersSyncronizeManager', 'file' => 'users_syncronize.php', 'build_event' => ''),
		Array('pseudo' => 'UsersSyncronize', 'class' => 'UsersSyncronize', 'file' => 'users_syncronize.php', 'build_event' => ''),
	),

	'AutoLoad' => true,

	'ConfigPriority' => 0,

	'Hooks' => Array (
		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => 'cdata',
			'DoSpecial' => '*',
			'DoEvent' => 'OnDefineCustomFields',
		),

		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'adm',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnStartup'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnAutoLoginUser',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'img',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnCloneSubItem',
		),

		// Captcha processing
		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => 'captcha',
			'DoSpecial' => '*',
			'DoEvent' => 'OnPrepareCaptcha',
		),

		/*Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnBeforeItemCreate'),
			'DoPrefix' => 'captcha',
			'DoSpecial' => '*',
			'DoEvent' => 'OnValidateCode',
		),*/
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'ScheduledTasks' => Array (
		'membership_expiration' => Array ('EventName' => 'OnCheckExpiredMembership', 'RunSchedule' => '*/30 * * * *'),
		'delete_expired_sessions' => Array ('EventName' => 'OnDeleteExpiredSessions', 'RunSchedule' => '0 */12 * * *'),
	),

	'IDField' => 'PortalUserId',

	'StatusField' => Array ('Status'),

	'TitleField' => 'Username',

	'ItemType' => 6, // used for custom fields only (on user's case)

	'StatisticsInfo' => Array (
		'pending' => Array (
			'icon' => 'icon16_user_pending.gif',
			'label' => 'la_Text_Users',
			'js_url' => '#url#',
			'url' => Array ('t' => 'users/users_list', 'pass' => 'm,u', 'u_event' => 'OnSetFilterPattern', 'u_filters' => 'show_active=0,show_pending=1,show_disabled=0'),
			'status' => STATUS_PENDING,
			),
	),

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('u' => '!la_title_Adding_User!'),
			'edit_status_labels' => Array ('u' => '!la_title_Editing_User!'),
		),

		'users_list' => Array (
			'prefixes' => Array ('u_List'), 'format' => "!la_title_Users!",
			'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'setprimary', 'approve', 'decline', 'frontend_mail', 'e-mail', 'export', 'view', 'dbl-click'),
		),

		'users_edit' => Array (
			'prefixes' => Array ('u'), 'format' => "#u_status# #u_titlefield# - !la_title_General!",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),

		'user_edit_images' => Array (
			'prefixes' => Array ('u', 'u-img_List'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Images!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_item', 'edit', 'delete', 'approve', 'decline', 'setprimary', 'move_up', 'move_down', 'view', 'dbl-click'),
		),

		'user_edit_groups' => Array (
			'prefixes' => Array ('u', 'u-ug_List'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Groups!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'select_user', 'edit', 'delete', 'setprimary', 'view', 'dbl-click'),
		),

		'user_edit_items' => Array (
			'prefixes' => Array ('u'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Items!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'edit', 'delete', 'view', 'dbl-click'),
		),

		'user_edit_custom' => Array (
			'prefixes' => Array ('u'), 'format' => "#u_status# '#u_titlefield#' - !la_title_Custom!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
		),

		'admin_list' => Array (
			'prefixes' => Array ('u.admins_List'), 'format' => "!la_title_Administrators!",
			'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'approve', 'decline', 'clone', 'refresh', 'view', 'dbl-click'),
		),

		'admins_edit' => Array (
			'new_status_labels' => Array ('u' => '!la_title_AddingAdministrator!'),
			'edit_status_labels' => Array ('u' => '!la_title_EditingAdministrator!'),
			'prefixes' => Array ('u'), 'format' => "#u_status# #u_titlefield#",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),

		'regular_users_list' => Array (
			'prefixes' => Array ('u.regular_List'), 'format' => "!la_title_Users!",
			'toolbar_buttons' => Array (),
		),

		'root_edit' => Array (
			'prefixes' => Array ('u'), 'format' => "!la_title_Editing_User! 'root'",
			'toolbar_buttons' => Array ('select', 'cancel'),
		),

		'user_edit_group' => Array (
			'prefixes' => Array ('u', 'u-ug'),
			'edit_status_labels' => Array ('u-ug' => '!la_title_EditingMembership!'),
			'format' => "#u_status# '#u_titlefield#' - #u-ug_status# '#u-ug_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
		),

		'user_image_edit' => Array (
			'prefixes' => Array ('u', 'u-img'),
			'new_status_labels' => Array ('u-img' => '!la_title_Adding_Image!'),
			'edit_status_labels' => Array ('u-img' => '!la_title_Editing_Image!'),
			'new_titlefield' => Array ('u-img' => '!la_title_New_Image!'),
			'format' => "#u_status# '#u_titlefield#' - #u-img_status# '#u-img_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
		),

		'user_select' => Array (
			'prefixes' => Array ('u_List'), 'format' => "!la_title_Users! - !la_title_SelectUser!",
			'toolbar_buttons' => Array ('select', 'cancel', 'dbl-click'),
		),

		'group_user_select' => Array (
			'prefixes' => Array ('u.group_List'), 'format' => "!la_title_Users! - !la_title_SelectUser!",
			'toolbar_buttons' => Array ('select', 'cancel', 'view', 'dbl-click'),
		),

		'tree_users' => Array ('format' => '!la_section_overview!'),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'users/users_edit', 'priority' => 1),
			'groups' => Array ('title' => 'la_tab_Groups', 't' => 'users/users_edit_groups', 'priority' => 2),
			'images' => Array ('title' => 'la_tab_Images', 't' => 'users/user_edit_images', 'priority' => 3),
			'items' => Array ('title' => 'la_tab_Items', 't' => 'users/user_edit_items', 'priority' => 4),
			'custom' => Array ('title' => 'la_tab_Custom', 't' => 'users/users_edit_custom', 'priority' => 5),
		),

		'Admins' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'users/admins_edit', 'priority' => 1),
			'groups' => Array ('title' => 'la_tab_Groups', 't' => 'users/admins_edit_groups', 'priority' => 2),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:user_list', 'custom' => 'in-portal:user_custom'),

	'Sections' => Array (
		'in-portal:user_list' => Array (
			'parent' => 'in-portal:users',
			'icon' => 'users',
			'label' => 'la_title_Users', // 'la_tab_User_List',
			'url' => Array ('t' => 'users/users_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete', 'advanced:ban', 'advanced:send_email', /*'advanced:add_favorite', 'advanced:remove_favorite',*/),
			'priority' => 1,
			'type' => stTREE,
		),

		'in-portal:admins' => Array (
			'parent' => 'in-portal:users',
			'icon' => 'administrators',
			'label' => 'la_title_Administrators',
			'url' => Array ('t' => 'users/admins_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'perm_prefix' => 'u',
			'priority' => 2,
			'type' => stTREE,
		),

		// user settings
		'in-portal:user_setting_folder' => Array (
			'parent' => 'in-portal:system',
			'icon' => 'conf_users',
			'label' => 'la_title_Users',
			'use_parent_header' => 1,
			'url' => Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view'),
			'priority' => 2,
			'container' => true,
			'type' => stTREE,
		),

		'in-portal:configure_users' => Array (
			'parent' => 'in-portal:user_setting_folder',
			'icon' => 'conf_users_general',
			'label' => 'la_tab_ConfigSettings',
			'url' => Array ('t' => 'config/config_universal', 'module' => 'In-Portal:Users', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit'),
			'priority' => 1,
			'type' => stTREE,
		),

		'in-portal:user_custom' => Array (
			'parent' => 'in-portal:user_setting_folder',
			'icon' => 'conf_customfields',
			'label' => 'la_tab_ConfigCustom',
			'url' => Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 6, 'pass_section' => true, 'pass' => 'm,cf'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 2,
			'type' => stTREE,
		),
	),

	'TableName' => TABLE_PREFIX.'Users',
	'CustomDataTableName' => TABLE_PREFIX . 'UserCustomData',

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s FROM %1$s
				LEFT JOIN '.TABLE_PREFIX.'UserGroups g ON %1$s.PrimaryGroupId = g.GroupId
				LEFT JOIN '.TABLE_PREFIX.'%3$sUserCustomData cust ON %1$s.ResourceId = cust.ResourceId
				LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1',

	'online' => '	SELECT %1$s.* %2$s FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'UserSessions s ON s.PortalUserId = %1$s.PortalUserId
					LEFT JOIN '.TABLE_PREFIX.'UserGroups g ON %1$s.PrimaryGroupId = g.GroupId
					LEFT JOIN '.TABLE_PREFIX.'%3$sUserCustomData cust ON %1$s.ResourceId = cust.ResourceId
					LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Username' => 'asc'),
		)
	),

	'SubItems' => Array ('addr', 'u-cdata', 'u-ug', 'u-img', 'fav', 'user-profile'),

	/**
	 * Required for depricated public profile templates to work
	 */
	'UserProfileMapping' => Array (
		'pp_firstname' => 'FirstName',
		'pp_lastname' => 'LastName',
		'pp_dob' => 'dob',
		'pp_email' => 'Email',
		'pp_phone' => 'Phone',
		'pp_street' => 'Street',
		'pp_city' => 'City',
		'pp_state' => 'State',
		'pp_zip' => 'Zip',
		'pp_country' => 'Country',
	),

	'CalculatedFields' => Array (
		'' => Array (
			'PrimaryGroup' => 'g.Name',
			'FullName' => 'CONCAT(%1$s.FirstName, " ", %1$s.LastName)',
			'AltName' => 'img.AltName',
			'SameImages' => 'img.SameImages',
			'LocalThumb' => 'img.LocalThumb',
			'ThumbPath' => 'img.ThumbPath',
			'ThumbUrl' => 'img.ThumbUrl',
			'LocalImage' => 'img.LocalImage',
			'LocalPath' => 'img.LocalPath',
			'FullUrl' => 'img.Url',
		),
	),

	'Forms' => Array (
		'default' => Array (
			'Fields' => Array (
				'PortalUserId' => Array ('default' => 0),
				'Username' => Array (
					'max_len' => 255,
					'formatter' => 'kFormatter', 'regexp' => '/^[A-Z\d_\-\.]+$/i',
					'error_msgs' => Array (
						'unique' => '!lu_user_already_exist!', 'invalid_format' => '!la_error_InvalidUsername!', 'banned' => '!la_error_UserBanned!'
					),
					'unique' => Array (), 'default' => '',
				),
				'Password' => Array (
					'formatter' => 'kPasswordFormatter', 'hashing_method_field' => 'PasswordHashingMethod', 'verify_field' => 'VerifyPassword',
					'default' => ''
				),
				'PasswordHashingMethod' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (
						PasswordHashingMethod::MD5 => 'md5',
						PasswordHashingMethod::MD5_AND_PHPPASS => 'md5+phppass',
						PasswordHashingMethod::PHPPASS => 'phppass'
					),
					'default' => PasswordHashingMethod::PHPPASS
				),
				'FirstName' => Array ('default' => ''),
				'LastName' => Array ('default' => ''),
				'Company' => Array ('default' => ''),
				'Email' => Array (
					'formatter' => 'kFormatter', 'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
					'sample_value' => 'email@domain.com', 'error_msgs' => Array (
						'invalid_format' => '!la_invalid_email!', 'unique' => '!lu_email_already_exist!'
					),
					'unique' => Array (), 'required' => 1, 'default' => ''
				),
				'CreatedOn' => Array ('formatter' => 'kDateFormatter', 'default' => '#NOW#'),
				'Phone' => Array ('default' => ''),
				'Fax' => Array ('default' => ''),
				'Street' => Array ('default' => ''),
				'Street2' => Array ('error_field' => 'Street', 'default' => ''),
				'City' => Array ('default' => ''),
				'State' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (),
					'default' => '',
				),
				'Zip' => Array ('default' => ''),
				'Country' => Array (
					'formatter' => 'kOptionsFormatter',
					'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
										FROM ' . TABLE_PREFIX . 'CountryStates
										WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
										ORDER BY Name',
					'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
					'default' => '',
				),
				'ResourceId' => Array ('default' => 0),
				'Status' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Enabled', 0 => 'la_Disabled', 2 => 'la_Pending'), 'use_phrases' => 1,
					'default' => 1
				),
				'Modified' => Array ('formatter' => 'kDateFormatter', 'default' => NULL),
				'dob' => Array ('formatter' => 'kDateFormatter', 'default' => NULL),
				'TimeZone' => Array ('default' => ''),
				'IPAddress' => Array ('default' => ''),
				'IsBanned' => Array ('default' => 0),
				'PwResetConfirm' => Array ('default' => ''),
				'PwRequestTime' => Array ('formatter' => 'kDateFormatter', 'default' => NULL),
				'FrontLanguage' => Array (
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages ORDER BY PackName',
					'option_key_field' => 'LanguageId', 'option_title_field' => 'LocalName', 'default' => NULL
				),
				'AdminLanguage' => Array (
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages ORDER BY PackName',
					'option_key_field' => 'LanguageId', 'option_title_field' => 'LocalName', 'default' => NULL
				),
				'DisplayToPublic' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (
						'FirstName' => 'lu_fld_FirstName', 'LastName' => 'lu_fld_LastName', 'dob' => 'lu_fld_BirthDate',
						'Email' => 'lu_fld_Email', 'Phone' => 'lu_fld_Phone', 'Street' => 'lu_fld_AddressLine1',
						'Street2' => 'lu_fld_AddressLine2', 'City' => 'lu_fld_City', 'State' => 'lu_fld_State',
						'Zip' => 'lu_fld_Zip', 'Country' => 'lu_fld_Country',
					), 'use_phrases' => 1, 'multiple' => 1,
					'default' => NULL
				),
				'UserType' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_opt_UserTypeUser', 1 => 'la_opt_UserTypeAdmin'), 'use_phrases' => 1,
					'default' => 0
				),
				'PrimaryGroupId' => Array (
					'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %1$s FROM ' . TABLE_PREFIX . 'UserGroups WHERE Enabled = 1 AND FrontRegistration = 1',
					'option_key_field' => 'GroupId', 'option_title_field' => 'Name', 'default' => NULL
				),
				'OldStyleLogin' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
					'default' => 0
				),
				'IPRestrictions' => Array ('default' => NULL),
				'EmailVerified' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
					'default' => 0
				),
				'PrevEmails' => Array ('default' => NULL),
			),

			'VirtualFields' => Array (
				'PrimaryGroup' => Array ('default' => ''),
				'RootPassword' => Array (
					'formatter' => 'kPasswordFormatter', 'hashing_method' => PasswordHashingMethod::PHPPASS, 'salt' => 'b38',
					'verify_field' => 'VerifyRootPassword', 'default' => 'b38:d41d8cd98f00b204e9800998ecf8427e'
				),
				'EmailPassword' => Array ('default' => ''),
				'FullName' => Array ('default' => ''),
				'AltName' => Array ('default' => ''),
				'SameImages' => Array ('default' => ''),
				'LocalThumb' => Array ('default' => ''),
				'ThumbPath' => Array ('default' => ''),
				'ThumbUrl' => Array ('default' => ''),
				'LocalImage' => Array ('default' => ''),
				'LocalPath' => Array ('default' => ''),
				'FullUrl' => Array ('default' => ''),

				'SubscribeToMailing' => Array (
					'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'lu_Yes', 0 => 'lu_No'), 'use_phrases' => 1,
					'default' => 0,
				),
			),
		),

		'registration' => Array (
			// Front-End user registration form
			/*'Fields' => Array (
				'FirstName' => Array ('required' => 1),
			),*/
		),

		'recommend' => Array (
			'VirtualFields' => Array (
				'RecommendEmail' => Array (
					'type' => 'string',
					'formatter' => 'kFormatter', 'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
					'error_msgs' => Array ('required' => '!lu_InvalidEmail!', 'invalid_format' => '!lu_InvalidEmail!', 'send_error' => '!lu_email_send_error!'),
					'sample_value' => 'email@domain.com',
					'required' => 1, 'default' => ''
				),
			),
		),

		'subscription' => Array (
			'VirtualFields' => Array (
				'SubscriberEmail' => Array (
					'type' => 'string',
					'formatter' => 'kFormatter', 'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
					'error_msgs' => Array ('required' => '!lu_InvalidEmail!', 'invalid_format' => '!lu_InvalidEmail!'),
					'sample_value' => 'email@domain.com',
					'required' => 1, 'default' => ''
				),
			),
		),

		'forgot_password' => Array (
			'VirtualFields' => Array (
				'ForgotLogin' => Array (
					'type' => 'string',
					'error_msgs' => Array (
						'required' => '!lu_ferror_forgotpw_nodata!',
						'unknown_username' => '!lu_ferror_unknown_username!',
						'unknown_email' => '!lu_ferror_unknown_email!',
						'reset_denied' => '!lu_ferror_reset_denied!',
					),
					'required' => 1, 'default' => ''
				),
			),
		),

		'login' => Array (
			'Fields' => Array (
				// make sure all fields, required by default are not required on this form
				'Email' => Array ('required' => 0),
			),
			'VirtualFields' => Array (
				'UserLogin' => Array (
					'type' => 'string',
					'error_msgs' => Array (
						'no_permission' => '!la_no_permissions!', 'invalid_password' => '!la_invalid_password!'
					),
					'default' => ''
				),
				'UserPassword' => Array ('type' => 'string', 'default' => ''),
				'UserRememberLogin' => Array ('type' => 'int', 'default' => 0),
			),
		),
	),

	'Fields' => Array (
		'PortalUserId' => Array ('type' => 'int', 'not_null' => 1),
		'Username' => Array ('type' => 'string', 'not_null' => 1),
		'Password' => Array ('type' => 'string', 'skip_empty' => 1),
		'PasswordHashingMethod' => Array ('type' => 'int'),
		'FirstName' => Array ('type' => 'string', 'not_null' => 1),
		'LastName' => Array ('type' => 'string', 'not_null' => 1),
		'Company' => Array ('type' => 'string', 'not_null' => 1),
		'Email' => Array ('type' => 'string', 'not_null' => 1),
		'CreatedOn' => Array ('type' => 'int'),
		'Phone' => Array ('type' => 'string', 'not_null' => 1),
		'Fax' => Array ('type' => 'string', 'not_null' => 1),
		'Street' => Array ('type' => 'string', 'not_null' => 1),
		'Street2' => Array ('type' => 'string', 'not_null' => 1),
		'City' => Array ('type' => 'string', 'not_null' => 1),
		'State' => Array ('type' => 'string', 'not_null' => 1),
		'Zip' => Array ('type' => 'string', 'not_null' => 1),
		'Country' => Array ('type' => 'string', 'not_null' => 1),
		'ResourceId' => Array ('type' => 'int', 'not_null' => 1),
		'Status' => Array ('type' => 'int', 'not_null' => 1),
		'Modified' => Array ('type' => 'int'),
		'dob' => Array ('type' => 'int'),
		'TimeZone' => Array ('type' => 'string', 'not_null' => 1),
		'IPAddress' => Array ('type' => 'string', 'not_null' => 1),
		'IsBanned' => Array ('type' => 'int', 'not_null' => 1),
		'PwResetConfirm' => Array ('type' => 'string', 'not_null' => 1),
		'PwRequestTime' => Array ('type' => 'int'),
		'FrontLanguage' => Array ('type' => 'int'),
		'AdminLanguage' => Array ('type' => 'int'),
		'DisplayToPublic' => Array ('type' => 'string'),
		'UserType' => Array ('type' => 'int', 'not_null' => 1),
		'PrimaryGroupId' => Array ('type' => 'int'),
		'OldStyleLogin' => Array ('type' => 'int', 'not_null' => 1),
		'IPRestrictions' => Array ('type' => 'string'),
		'EmailVerified' => Array ('type' => 'int', 'not_null' => 1),
		'PrevEmails' => Array ('type' => 'string'),
	),

	'VirtualFields' => Array (
		'PrimaryGroup' => Array ('type' => 'string'),
		'RootPassword' => Array ('type' => 'string', 'skip_empty' => 1),
		'EmailPassword' => Array ('type' => 'string'),
		'FullName' => Array ('type' => 'string'),
		'AltName' => Array ('type' => 'string'),
		'SameImages' => Array ('type' => 'string'),
		'LocalThumb' => Array ('type' => 'string'),
		'ThumbPath' => Array ('type' => 'string'),
		'ThumbUrl' => Array ('type' => 'string'),
		'LocalImage' => Array ('type' => 'string'),
		'LocalPath' => Array ('type' => 'string'),
		'FullUrl' => Array ('type' => 'string'),
		'SubscribeToMailing' => Array ('type' => 'int'),
	),

	'Grids' => Array (
		// not in use
		'Default' => Array (
			'Icons' => Array (
				0 => 'icon16_user_disabled.png',
				1 => 'icon16_user.png',
				2 => 'icon16_user_pending.png'
			),
			'Fields' => Array (
				'Username' => Array ('data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
				'LastName' => Array ('filter_block' => 'grid_like_filter'),
				'FirstName' => Array ('filter_block' => 'grid_like_filter'),
				'Email' => Array ('filter_block' => 'grid_like_filter'),
				'PrimaryGroup' => Array ('title' => 'la_col_PrimaryGroup', 'filter_block' => 'grid_like_filter'),
				'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter'),
				'Modified' => Array ('filter_block' => 'grid_date_range_filter'),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'IPAddress'		=> Array ('filter_block' => 'grid_like_filter', 'width' => 100, 'hidden' => 1),
			),
		),

		// used
		'UserSelector' => Array (
			'Icons' => Array (
				0 => 'icon16_user_disabled.png',
				1 => 'icon16_user.png',
				2 => 'icon16_user_pending.png'
			),
			'Selector' => 'radio',
			'Fields' => Array (
				'Username' => Array ('data_block' => 'grid_login_td', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
				'FirstName' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'LastName' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Email' => Array ('filter_block' => 'grid_like_filter', 'width' => 200, ),
				'PrimaryGroup' => Array ('title' => 'la_col_PrimaryGroup', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 150, ),
				'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 150, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'IPAddress'		=> Array ('filter_block' => 'grid_like_filter', 'width' => 100, 'hidden' => 1),
			),
		),

		// used
		'Admins' => Array (
			'Icons' => Array (
				0 => 'icon16_admin_disabled.png',
				1 => 'icon16_admin.png',
				2 => 'icon16_admin_disabled.png',
			),
			'Fields' => Array (
				'PortalUserId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70),
				'Username' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'FirstName' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'LastName' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Email' => Array ('filter_block' => 'grid_like_filter', 'width' => 200, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
			),
		),

		// used
		'RegularUsers' => Array (
			'Icons' => Array (
				0 => 'icon16_user_disabled.png',
				1 => 'icon16_user.png',
				2 => 'icon16_user_pending.png'
			),
			'Fields' => Array (
				'PortalUserId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70),
				'Username' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'FirstName' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'LastName' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Email' => Array ('filter_block' => 'grid_like_filter', 'width' => 200, ),
				'PrimaryGroup' => Array ('title' => 'la_col_PrimaryGroup', 'filter_block' => 'grid_like_filter', 'width' => 140),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'CreatedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 100),
				'Modified' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 100),
				'IPAddress' => Array ('filter_block' => 'grid_like_filter', 'width' => 100, 'hidden' => 1),
				'EmailVerified' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, 'hidden' => 1),
			),
		),
	),
);
