<?php
/**
* @version	$Id: form_submission_helper.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class FormSubmissionHelper extends kHelper {

		/**
		 * Role names for easy usage via FormField tag
		 *
		 * @var Array
		 */
		var $roleNames = Array (
			'name' => SubmissionFormField::COMMUNICATION_ROLE_NAME,
			'email' => SubmissionFormField::COMMUNICATION_ROLE_EMAIL,
			'subject' => SubmissionFormField::COMMUNICATION_ROLE_SUBJECT,
			'body' => SubmissionFormField::COMMUNICATION_ROLE_BODY,
		);

		/**
		 * Returns submission field based on given role
		 *
		 * @param kDBItem $form_submission
		 * @param string $role
		 * @param bool $formatted
		 * @param string $format
		 * @return string
		 */
		function getFieldByRole(&$form_submission, $role, $formatted = false, $format = null)
		{
			static $cache = Array ();

			$form_id = $form_submission->GetDBField('FormId');

			if (!array_key_exists($form_id, $cache)) {
				$id_field = $this->Application->getUnitOption('formflds', 'IDField');
				$table_name = $this->Application->getUnitOption('formflds', 'TableName');

				$sql = 'SELECT ' . $id_field . ', EmailCommunicationRole
						FROM ' . $table_name . '
						WHERE FormId = ' . $form_id . ' AND EmailCommunicationRole <> 0';
				$cache[$form_id] = $this->Conn->GetCol($sql, 'EmailCommunicationRole');
			}

			// convert string representation of role to numeric
			if (!is_numeric($role)) {
				$role = strtolower($role);
				$role = array_key_exists($role, $this->roleNames) ? $this->roleNames[$role] : false;
			}

			// get field by role
			$field_id = array_key_exists($role, $cache[$form_id]) ? $cache[$form_id][$role] : false;

			if ($field_id) {
				return $formatted ? $form_submission->GetField('fld_' . $field_id, $format) : $form_submission->GetDBField('fld_' . $field_id);
			}

			return false;
		}

		/**
		 * Returns submission field based on given name
		 *
		 * @param kDBItem $form_submission
		 * @param string $name
		 * @param bool $formatted
		 * @param string $format
		 * @return string
		 */
		function getFieldByName(&$form_submission, $name, $formatted = false, $format = null)
		{
			static $cache = Array ();

			$form_id = $form_submission->GetDBField('FormId');

			if (!array_key_exists($form_id, $cache)) {
				$id_field = $this->Application->getUnitOption('formflds', 'IDField');
				$table_name = $this->Application->getUnitOption('formflds', 'TableName');

				$sql = 'SELECT ' . $id_field . ', FieldName
						FROM ' . $table_name . '
						WHERE FormId = ' . $form_id;
				$cache[$form_id] = $this->Conn->GetCol($sql, 'FieldName');
			}

			// get field by name
			$field_id = array_key_exists($name, $cache[$form_id]) ? $cache[$form_id][$name] : false;

			if ($field_id) {
				return $formatted ? $form_submission->GetField('fld_' . $field_id, $format) : $form_submission->GetDBField('fld_' . $field_id);
			}

			return false;
		}

		/**
		 * Returns form object field based on form submission
		 *
		 * @param $form_submission kDBItem
		 * @return kDBItem
		 */
		function &getForm(&$form_submission)
		{
			$form_id = $form_submission->GetDBField('FormId');

			/** @var kDBItem $form */
			$form = $this->Application->recallObject('form', null, Array ('skip_autoload' => true));

			if ( !$form->isLoaded() || ($form->GetID() != $form_id) ) {
				$form->Load($form_id);
			}

			return $form;
		}

		/**
		 * Returns form submission based on given submission log
		 *
		 * @param kDBItem $submission_log
		 * @return kDBItem
		 * @access public
		 */
		public function getSubmissionFromLog($submission_log)
		{
			$submission_id = $submission_log->GetDBField('FormSubmissionId');

			/** @var kDBItem $form_submission */
			$form_submission = $this->Application->recallObject('formsubs.-item', null, Array ('skip_autoload' => true));

			if ( $form_submission->isLoaded() && ($form_submission->GetID() == $submission_id) ) {
				return $form_submission;
			}

			$form_submission->Load($submission_id);

			return $form_submission;
		}
	}