<?php
/**
* @version	$Id: draft_eh.php 16513 2017-01-20 14:10:53Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class DraftEventHandler extends kDBEventHandler
	{
		/**
		 * Sets user, who created draft
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemCreate(kEvent $event)
		{
			parent::OnBeforeItemCreate($event);

			/** @var kDBItem $object */
			$object = $event->getObject();

			$user_id = $this->Application->RecallVar('user_id');

			$object->SetDBField('CreatedById', $user_id);
		}

		/**
		 * Allows to load draft, that best matches given form submission
		 *
		 * @param kEvent $event
		 * @return int
		 * @access public
		 */
		public function getPassedID(kEvent $event)
		{
			if ( $event->Special == 'related' ) {
				/** @var kDBItem $form_submission */
				$form_submission = $this->Application->recallObject('formsubs');

				return Array (
					'FormSubmissionId' => $form_submission->GetID(),
					'CreatedById' => $this->Application->RecallVar('user_id'),
				);
			}

			return parent::getPassedID($event);
		}
	}