<inp2:m_include t="incs/header"/>

<inp2:m_Get name="section" result_to_var="section"/>
<inp2:m_RenderElement name="combined_header" prefix="conf" section="$section" perm_event="conf:OnLoad" title_preset="config_list_general"/>

<!-- ToolBar -->
<table class="toolbar" height="30" cellspacing="0" cellpadding="0" width="100%" border="0">
	<tbody>
		<tr>
  			<td>
  				<script type="text/javascript">
					function validate_password_fields() {
						var $validated = true;

						$("input[primarytype='password']", '#' + $form_name).each(
							function ($e) {
								if ( !validate_password_field(this.id) ) {
									$validated = false;
								}
							}
						);

						return $validated;
					}

					function validate_password_field($field_id) {
						var password_field = document.getElementById($field_id),
							password_verify_field = document.getElementById('verify_' + $field_id);

						if ( password_field && password_verify_field && password_field.value == password_verify_field.value ) {
							return true;
						}
						else {
							var password_error_cell = document.getElementById('error_' + $field_id);

							if ( password_error_cell ) {
								$(window).scrollTop($(password_field).position().top - 15);
								password_error_cell.innerHTML = '<inp2:m_Phrase name="la_error_PasswordMatch"/>';
							}

							return false;
						}
					}

					function toggle_section($label) {
						var $table = document.getElementById('config_table');
						var $row = null;
						var $is_visible = false;

						for (var $i = 0; $i < $table.rows.length; $i++) {
							$row = $table.rows[$i];
							if ( $row.getAttribute('header_label') != $label ) {
								continue;
							}

							if ( !$row.style.display ) {
								$row.style.display = document.all ? 'block' : 'table-row';
							}

							$is_visible = !($row.style.display == 'none');
							$row.style.display = $is_visible ? 'none' : (document.all ? 'block' : 'table-row');

							document.getElementById('toggle_mark[' + $label + ']').innerHTML = '[' + ($is_visible ? '+' : '-') + ']';
						}
					}

  					var a_toolbar = new ToolBar();

					a_toolbar.AddButton(
						new ToolBarButton(
							'select',
							'<inp2:m_phrase label="la_ToolTip_Save" escape="1"/>',
							function() {
								submit_event('conf','<inp2:conf_SaveEvent/>');
							}
						)
					);

					a_toolbar.AddButton(
						new ToolBarButton(
							'cancel',
							'<inp2:m_phrase label="la_ToolTip_Cancel" escape="1"/>',
							function() {
								submit_event('conf','OnCancel');
							}
					 	)
					);

					<inp2:m_if check="m_IsDebugMode">
						a_toolbar.AddButton( new ToolBarSeparator('sep1') );

						a_toolbar.AddButton(
							new ToolBarButton(
								'new_item',
								'<inp2:m_phrase label="la_ToolTip_NewSystemSetting" escape="1"/>::<inp2:m_phrase label="la_ToolTip_Add" escape="1"/>',
								function() {
									std_precreate_item('conf', 'config/config_edit');
								}
							)
						);
					</inp2:m_if>

					<inp2:m_ModuleInclude template = "config/custom_toolbar"/>

					a_toolbar.Render();
				</script>
			</td>
		</tr>
	</tbody>
</table>

<inp2:m_include t="incs/config_blocks"/>

<inp2:m_RenderElement name="config_updated_notice"/>
<inp2:conf_SaveWarning name="grid_save_warning"/>

<table width="100%" border="0" cellspacing="0" cellpadding="4" class="bordered" id="config_table">
	<!-- module root category selector: begin -->
	<tr class="subsectiontitle">
		<td colspan="2">
	    		<inp2:m_phrase name="la_Text_RootCategory" />
	   		</td>
   		<td align="right">
   			<a class="config-header" href="javascript:toggle_section('la_Text_RootCategory');" id="toggle_mark[la_Text_RootCategory]" title="Collapse/Expand Section">[-]</a>
   		</td>
	</tr>

	<tr class="<inp2:m_odd_even odd="table-color1" even="table-color2"/>" header_label="la_Text_RootCategory">
		<td>
			<span class="text"><inp2:m_phrase name="la_prompt_RootCategory" /></span>
		</td>
		<td>
			<inp2:m_DefineElement name="category_caption">
				<inp2:m_ifnot check="m_Param" name="is_first">
					<inp2:m_param name="separator"/>
				</inp2:m_ifnot>
				<inp2:m_param name="cat_name"/>
			</inp2:m_DefineElement>

			<b><inp2:conf_CategoryPath separator=" &gt; " render_as="category_caption" /></b>
			<input type="hidden" name="conf[ModuleRootCategory][VariableValue]" value="<inp2:conf_ModuleRootCategory/>"/>
			<a href="<inp2:adm_SelectorLink prefix='conf' selection_mode='single' tab_prefixes='none'/>" onclick="openSelector('conf', this.href, 'ModuleRootCategory', '950x600'); return false;"><img src="img/icons/icon24_cat.gif" border="0" align="absmiddle" /></a>
		</td>
		<td class="error">&nbsp;</td>
	</tr>
	<!-- module root category selector: end -->

	<inp2:conf_PrintList block="config_block" per_page="-1" full_block="config_block" half_block1="config_block1" half_block2="config_block2" value_render_as="cf_default_value"/>
</table>

<script type="text/javascript">
	<inp2:m_if check="m_Get" name="refresh_tree">
		getFrame('menu').location.reload();
	</inp2:m_if>

	<inp2:m_if check="m_Get" name="refresh_all">
		var $menu_frame = getFrame('menu');

		$menu_frame.parent.location.href = $menu_frame.parent.location.href;
	</inp2:m_if>

	Application.setHook(
		'conf:*',
		function ($event) {
			$event.status = $event.Name == 'OnCancel' ? true : validate_password_fields();
		}
	);

	<inp2:m_if check="m_Get" name="first_error">
		$(document).ready(function () {
			var $error_cell = $('.field-<inp2:m_Get name="first_error" js_escape="1"/>.error');

			if ( $error_cell.length ) {
				$(window).scrollTop($error_cell.position().top - 15);
			}
		});
	</inp2:m_if>
</script>

<inp2:m_include t="incs/footer"/>
