<?php
/**
* @version	$Id: stylesheets_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'css',
	'ItemClass' => Array ('class' => 'StylesheetsItem', 'file' => 'stylesheets_item.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'StylesheetsEventHandler', 'file' => 'stylesheets_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'Hooks' => Array (
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'css',
			'HookToSpecial' => '',
			'HookToEvent' => Array ('OnSave'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnCompileStylesheet',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'StylesheetId',

	'StatusField' => Array ('Enabled'),

	'TitleField' => 'Name',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('css' => '!la_title_Adding_Stylesheet!'),
			'edit_status_labels' => Array ('css' => '!la_title_Editing_Stylesheet!'),
			'new_titlefield' => Array ('css' => '!la_title_New_Stylesheet!'),
		),

		'styles_list' => Array (
			'prefixes' => Array ('css_List'), 'format' => "!la_title_Stylesheets!",
			'toolbar_buttons' => Array ('new_style', 'edit', 'delete', 'approve', 'decline', 'clone', 'view', 'dbl-click'),
		),

		'stylesheets_edit' => Array (
			'prefixes' => Array ('css'), 'format' => "#css_status# '#css_titlefield#' - !la_title_General!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next'),
		),

		'base_styles' => Array (
			'prefixes' => Array ('css', 'selectors.base_List'), 'format' => "#css_status# '#css_titlefield#' - !la_title_BaseStyles!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_selector', 'edit', 'delete', 'clone', 'view', 'dbl-click'),
		),

		'block_styles' => Array (
			'prefixes' => Array ('css', 'selectors.block_List'), 'format' => "#css_status# '#css_titlefield#' - !la_title_BlockStyles!",
			'toolbar_buttons' => Array ('select', 'cancel', 'prev', 'next', 'new_selector', 'edit', 'delete', 'clone', 'reset_to_base', 'view', 'dbl-click'),
		),

		'base_style_edit' => Array (
			'prefixes' => Array ('css', 'selectors',),
			'new_status_labels' => Array ('selectors' => '!la_title_Adding_BaseStyle!'),
			'edit_status_labels' => Array ('selectors' => '!la_title_Editing_BaseStyle!'),
			'new_titlefield' => Array ('selectors' => '!la_title_New_BaseStyle!'),
			'format' => "#css_status# '#css_titlefield#' - #selectors_status# '#selectors_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel'),
		),

		'block_style_edit' => Array (
			'prefixes' => Array ('css', 'selectors'),
			'new_status_labels' => Array ('selectors' => '!la_title_Adding_BlockStyle!'),
			'edit_status_labels' => Array ('selectors' => '!la_title_Editing_BlockStyle!'),
			'new_titlefield' => Array ('selectors' => '!la_title_New_BlockStyle!'),
			'format' => "#css_status# '#css_titlefield#' - #selectors_status# '#selectors_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_to_base'),
		),

		'style_edit' => Array (
			'prefixes' => Array ('selectors'), 'format' => "!la_title_EditingStyle! '#selectors_titlefield#'",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_to_base'),
		),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'stylesheets/stylesheets_edit', 'priority' => 1),
			'block_styles' => Array ('title' => 'la_tab_BlockStyles', 't' => 'stylesheets/stylesheets_edit_block', 'priority' => 2),
			'base_styles' => Array ('title' => 'la_tab_BaseStyles', 't' => 'stylesheets/stylesheets_edit_base', 'priority' => 3),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:configure_styles'),
/* removed until figure out what to do with this section
	'Sections' => Array (
		'in-portal:configure_styles' => Array (
			'parent' => 'in-portal:website_setting_folder',
			'icon' => 'style',
			'label' => 'la_tab_Stylesheets',
			'url' => Array ('t' => 'stylesheets/stylesheets_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 10,
			'type' => stTREE,
		),
	),
*/
	'TableName' => TABLE_PREFIX.'Stylesheets',
	'SubItems' => Array ('selectorsbase', 'selectorsblock'),

	'AutoDelete' => true,

	'AutoClone' => true,

	'ListSQLs' => Array (
		'' => '	SELECT *
				FROM %s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Name' => 'asc'),
		),
	),

	'Fields' => Array (
		'StylesheetId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Name' => Array ('type' => 'string', 'not_null' => '1', 'default' => '', 'required'=>1),
		'Description' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
		'AdvancedCSS' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
		'LastCompiled' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		'Enabled' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options'=>Array (0 => 'la_Disabled', 1 => 'la_Enabled'), 'use_phrases' => 1, 'not_null' => '1', 'default' => 0),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				0 => 'icon16_disabled.png',
				1 => 'icon16_item.png'
			),
			'Fields' => Array (
				'Name' => Array ('data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_like_filter'),
				'Description' => Array ('first_chars' => 100, 'filter_block' => 'grid_like_filter'),
				'Enabled' => Array ('title' => 'column:la_fld_Status', 'filter_block' => 'grid_options_filter'),
				'LastCompiled' => Array ('title' => 'la_col_LastCompiled', 'filter_block' => 'grid_date_range_filter'),
			),
		),
	),
);