<?php
/**
* @version	$Id: site_domains_config.php 16388 2016-08-11 08:16:43Z alex $
* @package	In-Portal
* @copyright	Copyright (C) 1997 - 2010 Intechnic. All rights reserved.
* @license      GNU/GPL
* In-Portal is Open Source software.
* This means that this software may have been modified pursuant
* the GNU General Public License, and as distributed it includes
* or is derivative of works licensed under the GNU General Public License
* or other free or open source software licenses.
* See http://www.in-portal.org/license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'site-domain',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'SiteDomainEventHandler', 'file' => 'site_domain_eh.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'kDBTagProcessor', 'file' => '', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'event',
		4 => 'mode',
	),

	'IDField' => 'DomainId',

	'TableName' => TABLE_PREFIX . 'SiteDomains',

	'TitleField' => 'DomainName',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('site-domain' => '!la_title_AddingSiteDomain!'),
			'edit_status_labels' => Array ('site-domain' => '!la_title_EditingSiteDomain!'),
		),

		'site_domain_list' => Array (
			'prefixes' => Array ('site-domain_List'), 'format' => "!la_title_SiteDomains!",
			'toolbar_buttons' => Array ('new_item', 'edit', 'delete', 'view', 'dbl-click'),
		),

		'site_domain_edit' => Array (
			'prefixes' => Array ('site-domain'), 'format' => "#site-domain_status# '#site-domain_titlefield#' - !la_title_General!",
			'toolbar_buttons' => Array ('select', 'cancel', 'reset_edit', 'prev', 'next'),
		),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'site_domains/site_domain_edit', 'priority' => 1),
		),
	),

	'PermSection' => Array ('main' => 'in-portal:site_domains'),

	'Sections' => Array (
		'in-portal:site_domains' => Array (
			'parent' => 'in-portal:website_setting_folder',
			'icon' => 'site_domain',
			'label' => 'la_title_SiteDomains',
			'url' => Array ('t' => 'site_domains/site_domain_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 7,
			'type' => stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Priority' => 'desc', 'DomainName' => 'asc'),
		)
	),

	'Fields' => Array (
		'DomainId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'DomainName' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'required' => 1, 'default' => ''),
		'DomainNameUsesRegExp' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'SSLUrl' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'SSLUrlUsesRegExp' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'AdminEmail' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'DefaultEmailRecipients' => Array ('type' => 'string', 'default' => NULL),
		'Country' => Array (
			'type' => 'string', 'max_len' => 3,
			'formatter' => 'kOptionsFormatter',
			'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
								FROM ' . TABLE_PREFIX . 'CountryStates
								WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
								ORDER BY Name',
			'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
			'not_null' => 1, 'default' => ''
		),
		'PrimaryLanguageId' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages WHERE Enabled = 1 ORDER BY PackName ASC', 'option_key_field' => 'LanguageId', 'option_title_field' => 'PackName',
			'not_null' => 1, 'default' => 0
		),
		'Languages' => Array (
			'type' => 'string', 'max_len' => 255,
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Languages WHERE Enabled = 1 ORDER BY PackName ASC', 'option_key_field' => 'LanguageId', 'option_title_field' => 'PackName',
			'not_null' => 1, 'default' => ''
		),
		'PrimaryThemeId' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Themes WHERE Enabled = 1 ORDER BY Name ASC', 'option_key_field' => 'ThemeId', 'option_title_field' => 'Name',
			'not_null' => 1, 'default' => 0
		),
		'Themes' => Array (
			'type' => 'string', 'max_len' => 255,
			'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Themes WHERE Enabled = 1 ORDER BY Name ASC', 'option_key_field' => 'ThemeId', 'option_title_field' => 'Name',
			'not_null' => 1, 'default' => ''
		),
		'DomainIPRange' => Array ('type' => 'string', 'default' => NULL),
		'ExternalUrl' => Array ('type' => 'string', 'max_len' => 255, 'not_null' => 1, 'default' => ''),
		'RedirectOnIPMatch' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Disabled', 1 => 'la_opt_CurrentDomain', 2 => 'la_opt_ExternalUrl'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0
		),
		'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array ('default' => 'icon16_item.png'),
			'Fields' => Array (
				'DomainId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
				'DomainName' => Array ('filter_block' => 'grid_like_filter', 'width' => 250, ),
				'SSLUrl' => Array ('filter_block' => 'grid_like_filter', 'width' => 250, ),
				'Country' => Array ('filter_block' => 'grid_options_filter', 'width' => 250, ),
				'PrimaryLanguageId' => Array ('title' => 'column:la_fld_Language', 'filter_block' => 'grid_options_filter', 'width' => 250, ),
				'PrimaryThemeId' => Array ('title' => 'column:la_fld_Theme', 'filter_block' => 'grid_options_filter', 'width' => 250, ),
				'Priority' => Array ('filter_block' => 'grid_range_filter', 'width' => 70, ),
			),
		),
	),
);